/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content.client;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.puzzleslib.api.client.event.v1.gui.ScreenEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_11907;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5699;
import net.minecraft.class_7417;
import org.jspecify.annotations.Nullable;

public final class ScreenSkipper {
    public static final Codec<ScreenSkipper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("screen_title_translation_key").forGetter(config -> ScreenSkipper.getOptionalComponent(config.titleComponent)), (App)Codec.STRING.optionalFieldOf("button_translation_key").forGetter(config -> ScreenSkipper.getOptionalComponent(config.buttonComponent)), (App)Codec.STRING.optionalFieldOf("last_screen_title_translation_key").forGetter(config -> ScreenSkipper.getOptionalComponent(config.lastTitleComponent)), (App)class_5699.field_33442.optionalFieldOf("skip_buttons").forGetter(config -> config.skipButtons > 0 ? Optional.of(config.skipButtons) : Optional.empty()), (App)Codec.BOOL.optionalFieldOf("single_trigger").forGetter(config -> config.singleTrigger ? Optional.of(config.singleTrigger) : Optional.empty())).apply((Applicative)instance, ScreenSkipper::new));
    private final @Nullable class_2561 titleComponent;
    private final @Nullable class_2561 buttonComponent;
    private final @Nullable class_2561 lastTitleComponent;
    private final int skipButtons;
    private final boolean singleTrigger;
    private EventResult trigger;

    static Optional<String> getOptionalComponent(@Nullable class_2561 component) {
        class_7417 class_74172;
        if (component != null && (class_74172 = component.method_10851()) instanceof class_2588) {
            class_2588 contents = (class_2588)class_74172;
            return Optional.of(contents.method_11022());
        }
        return Optional.empty();
    }

    private ScreenSkipper(Optional<String> titleComponent, Optional<String> buttonComponent, Optional<String> lastTitleComponent, Optional<Integer> skipButtons, Optional<Boolean> singleTrigger) {
        this(titleComponent.map(class_2561::method_43471).orElse(null), buttonComponent.map(class_2561::method_43471).orElse(null), lastTitleComponent.map(class_2561::method_43471).orElse(null), skipButtons.orElse(0), singleTrigger.orElse(false));
    }

    private ScreenSkipper() {
        this(null, null, null, 0, false);
    }

    private ScreenSkipper(@Nullable class_2561 titleComponent, @Nullable class_2561 buttonComponent, @Nullable class_2561 lastTitleComponent, int skipButtons, boolean singleTrigger) {
        this.titleComponent = titleComponent;
        this.buttonComponent = buttonComponent;
        this.lastTitleComponent = lastTitleComponent;
        this.skipButtons = skipButtons;
        this.singleTrigger = singleTrigger;
    }

    public static ScreenSkipper create() {
        return new ScreenSkipper();
    }

    public ScreenSkipper setTitleComponent(String titleKey) {
        return this.setTitleComponent((class_2561)class_2561.method_43471((String)titleKey));
    }

    public ScreenSkipper setTitleComponent(class_2561 titleComponent) {
        return new ScreenSkipper(titleComponent, this.buttonComponent, this.lastTitleComponent, this.skipButtons, this.singleTrigger);
    }

    public ScreenSkipper setButtonComponent(String buttonKey) {
        return this.setButtonComponent((class_2561)class_2561.method_43471((String)buttonKey));
    }

    public ScreenSkipper setButtonComponent(class_2561 buttonComponent) {
        return new ScreenSkipper(this.titleComponent, buttonComponent, this.lastTitleComponent, this.skipButtons, this.singleTrigger);
    }

    public ScreenSkipper setLastTitleComponent(String lastTitleKey) {
        return this.setLastTitleComponent((class_2561)class_2561.method_43471((String)lastTitleKey));
    }

    public ScreenSkipper setLastTitleComponent(class_2561 lastTitleComponent) {
        return new ScreenSkipper(this.titleComponent, this.buttonComponent, lastTitleComponent, this.skipButtons, this.singleTrigger);
    }

    public ScreenSkipper setSkipButtons(int skipButtons) {
        return new ScreenSkipper(this.titleComponent, this.buttonComponent, this.lastTitleComponent, skipButtons, this.singleTrigger);
    }

    public ScreenSkipper setSingleTrigger() {
        return new ScreenSkipper(this.titleComponent, this.buttonComponent, this.lastTitleComponent, this.skipButtons, true);
    }

    public void build() {
        Preconditions.checkState((this.titleComponent != null || this.lastTitleComponent != null ? 1 : 0) != 0, (Object)"screen not specified");
        this.setTriggerProperty(false);
        ScreenEvents.afterInit(class_437.class).register(this::onAfterInit);
        if (this.lastTitleComponent != null) {
            ScreenEvents.remove(class_437.class).register(screen -> {
                if (this.trigger == EventResult.PASS && screen.method_25440().equals((Object)this.lastTitleComponent)) {
                    this.trigger = EventResult.ALLOW;
                }
            });
        }
    }

    private void setTriggerProperty(boolean triggered) {
        this.trigger = triggered && this.singleTrigger ? EventResult.DENY : (this.lastTitleComponent != null ? EventResult.PASS : EventResult.ALLOW);
    }

    private void onAfterInit(class_310 minecraft, class_437 screen, int screenWidth, int screenHeight, List<class_339> widgets, UnaryOperator<class_339> addWidget, Consumer<class_339> removeWidget) {
        if (this.trigger == EventResult.ALLOW && (this.titleComponent == null || screen.method_25440().equals((Object)this.titleComponent))) {
            this.iterateAllWidgets(widgets, this.skipButtons);
        }
    }

    private void iterateAllWidgets(List<? extends class_364> widgets, int skipButtons) {
        for (class_364 class_3642 : widgets) {
            if (class_3642 instanceof class_4185) {
                class_4185 button = (class_4185)class_3642;
                if (this.buttonComponent != null && !button.method_25369().equals((Object)this.buttonComponent) || skipButtons-- > 0) continue;
                button.method_25306((class_11907)new class_11910(0, 0));
                this.setTriggerProperty(true);
                break;
            }
            if (!(class_3642 instanceof class_4069)) continue;
            class_4069 containerEventHandler = (class_4069)class_3642;
            this.iterateAllWidgets(containerEventHandler.method_25396(), skipButtons);
        }
    }
}

