/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1078;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class ConfigTranslationsManager
implements class_4013 {
    public static final ConfigTranslationsManager INSTANCE = new ConfigTranslationsManager();
    private final Map<String, String> translations = new ConcurrentHashMap<String, String>();

    private ConfigTranslationsManager() {
    }

    public void method_14491(class_3300 resourceManager) {
        class_2477 class_24772 = class_2477.method_10517();
        if (class_24772 instanceof class_1078) {
            class_1078 clientLanguage = (class_1078)class_24772;
            if (!(clientLanguage.field_5330 instanceof HashMap)) {
                clientLanguage.field_5330 = new HashMap(clientLanguage.field_5330);
            }
            this.translations.forEach(clientLanguage.field_5330::putIfAbsent);
        }
    }

    public void addModConfig(String modId, String configType, String fileName, ModConfigSpec configSpec) {
        this.addConfigTitle(modId);
        this.addConfigFile(modId, fileName, configType);
        this.addConfigValues(modId, configSpec.getSpec(), new ArrayList<String>(), arg_0 -> ((ModConfigSpec)configSpec).getLevelComment(arg_0));
    }

    private void addConfigValues(String modId, UnmodifiableConfig config, List<String> path, Function<List<String>, @Nullable String> levelCommentGetter) {
        for (UnmodifiableConfig.Entry entry : config.entrySet()) {
            String comment;
            this.addConfigValue(modId, entry.getKey());
            Object object = entry.getValue();
            if (object instanceof ModConfigSpec.ValueSpec) {
                ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)object;
                comment = valueSpec.getComment();
            } else if (entry.getValue() instanceof UnmodifiableConfig) {
                path = new ArrayList<String>(path);
                path.add(entry.getKey());
                comment = levelCommentGetter.apply(path);
                this.addConfigValues(modId, (UnmodifiableConfig)entry.getValue(), path, levelCommentGetter);
            } else {
                comment = null;
            }
            this.addConfigValueComment(modId, entry.getKey(), comment);
            this.addConfigValueButton(modId, entry.getKey());
        }
    }

    public void addConfigTitle(String modId) {
        this.translations.put(modId + ".configuration.title", "%s Configuration");
    }

    public void addConfigFile(String modId, String fileName, String configType) {
        configType = ConfigTranslationsManager.getConfigTypeFromFileName(fileName).orElse(configType);
        configType = ConfigTranslationsManager.getCapitalizedString(configType);
        fileName = fileName.replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase();
        this.translations.put(modId + ".configuration.section." + fileName, "%s " + configType + " Settings");
        this.translations.put(modId + ".configuration.section." + fileName + ".title", "%s " + configType + " Configuration");
    }

    private static Optional<String> getConfigTypeFromFileName(String fileName) {
        int startIndex = fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf(46);
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            return Optional.of(fileName.substring(startIndex + 1, endIndex));
        }
        return Optional.empty();
    }

    public void addConfigValue(String modId, String valueName) {
        Objects.requireNonNull(valueName, "value name is null");
        this.addConfigValue(modId, Collections.singletonList(valueName));
    }

    public void addConfigValue(String modId, List<String> valuePath) {
        this.translations.put(modId + ".configuration." + valuePath.getLast(), ConfigTranslationsManager.getCapitalizedString(valuePath.getLast()));
    }

    public void addConfigValueComment(String modId, String valueName, @Nullable String comment) {
        Objects.requireNonNull(valueName, "value name is null");
        this.addConfigValueComment(modId, Collections.singletonList(valueName), (List<String>)(comment != null ? new ArrayList<String>(Arrays.asList(comment.split("\\R"))) : Collections.emptyList()));
    }

    public void addConfigValueComment(String modId, List<String> valuePath, List<String> comments) {
        String value = String.join((CharSequence)System.lineSeparator(), ConfigTranslationsManager.getStylizedStrings(comments));
        this.translations.put(modId + ".configuration." + valuePath.getLast() + ".tooltip", value);
    }

    public void addConfigValueButton(String modId, String valueName) {
        Objects.requireNonNull(valueName, "value name is null");
        this.addConfigValueButton(modId, Collections.singletonList(valueName));
    }

    public void addConfigValueButton(String modId, List<String> valuePath) {
        this.translations.put(valuePath.getLast() + ".button", "Edit...");
        this.translations.put(modId + ".configuration." + valuePath.getLast() + ".button", "Edit...");
    }

    private static String getCapitalizedString(String s) {
        String[] strings = s.toLowerCase().split("[\\s_]+");
        StringJoiner joiner = new StringJoiner(" ");
        for (String string : strings) {
            joiner.add(StringUtils.capitalize((String)string));
        }
        return joiner.toString().replace(" And ", " & ").replace(" Or ", " / ");
    }

    private static List<String> getStylizedStrings(List<String> strings) {
        strings.removeIf(string -> string.matches("^ Default: .*"));
        for (int i = 0; i < strings.size(); ++i) {
            String string2 = strings.get(i).replaceAll("^ Range: ", "Value Range: ");
            class_124 chatFormatting = i % 2 == 0 ? class_124.field_1054 : class_124.field_1065;
            strings.set(i, String.valueOf(chatFormatting) + string2 + String.valueOf(class_124.field_1070));
        }
        return strings;
    }
}

