/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.attachment.v4.DataAttachmentType;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_5455;
import org.jspecify.annotations.Nullable;

public final class DataAttachmentTypeImpl<T, V>
implements DataAttachmentType<T, V> {
    private final AttachmentTypeAdapter<T, V> attachmentType;
    private final Function<T, class_5455> registryAccessExtractor;
    private final Map<Predicate<T>, Function<class_5455, V>> defaultValues;

    public DataAttachmentTypeImpl(AttachmentTypeAdapter<T, V> attachmentType, Function<T, class_5455> registryAccessExtractor, Map<Predicate<T>, Function<class_5455, V>> defaultValues) {
        this.attachmentType = attachmentType;
        this.registryAccessExtractor = registryAccessExtractor;
        this.defaultValues = ImmutableMap.copyOf(defaultValues);
    }

    private @Nullable V getDefaultValue(T holder) {
        for (Map.Entry<Predicate<T>, Function<class_5455, V>> entry : this.defaultValues.entrySet()) {
            if (!entry.getKey().test(holder)) continue;
            return entry.getValue().apply(this.registryAccessExtractor.apply(holder));
        }
        return null;
    }

    @Override
    public @Nullable V get(T holder) {
        V defaultValue;
        if (!this.attachmentType.hasData(holder) && (defaultValue = this.getDefaultValue(holder)) != null) {
            this.attachmentType.setData(holder, defaultValue);
        }
        if (this.attachmentType.hasData(holder)) {
            V value = this.attachmentType.getData(holder);
            Objects.requireNonNull(value, () -> "value for " + String.valueOf(this.attachmentType.identifier()) + " is null");
            return value;
        }
        return null;
    }

    @Override
    public V getOrDefault(T holder, V defaultValue) {
        V value = this.get(holder);
        return value != null ? value : defaultValue;
    }

    @Override
    public boolean has(T holder) {
        return this.attachmentType.hasData(holder) || this.getDefaultValue(holder) != null;
    }

    @Override
    public void set(T holder, @Nullable V newValue) {
        Object oldValue;
        Object v0 = oldValue = this.attachmentType.hasData(holder) ? this.attachmentType.getData(holder) : null;
        if (!Objects.equals(oldValue, newValue)) {
            if (newValue != null) {
                this.attachmentType.setData(holder, newValue);
            } else {
                this.attachmentType.removeData(holder);
            }
        }
    }

    @Override
    public void apply(T holder, UnaryOperator<V> valueUpdater) {
        this.set(holder, valueUpdater.apply(this.get(holder)));
    }
}

