/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.core.context;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.core.v1.context.DataPackReloadListenersContext;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.resource.v1.DataResourceLoader;
import net.fabricmc.fabric.api.resource.v1.reloader.ResourceReloaderKeys;
import net.minecraft.class_2960;
import net.minecraft.class_5350;
import net.minecraft.class_7225;

public final class DataPackReloadListenersContextFabricImpl
implements DataPackReloadListenersContext {
    private static final Map<class_2960, class_2960> VANILLA_SERVER_RELOAD_LISTENERS = ImmutableMap.builder().put((Object)RECIPES, (Object)ResourceReloaderKeys.Server.RECIPES).put((Object)FUNCTIONS, (Object)ResourceReloaderKeys.Server.FUNCTIONS).put((Object)ADVANCEMENTS, (Object)ResourceReloaderKeys.Server.ADVANCEMENTS).build();
    private static final ThreadLocal<WeakReference<class_5350>> RELOADABLE_SERVER_RESOURCES_REFERENCE = ThreadLocal.withInitial(() -> new WeakReference<Object>(null));

    public static void setReloadableServerResources(class_5350 reloadableServerResources) {
        RELOADABLE_SERVER_RESOURCES_REFERENCE.set(new WeakReference<class_5350>(reloadableServerResources));
    }

    @Override
    public void registerReloadListener(class_2960 identifier, DataPackReloadListenersContext.PreparableReloadListenerFactory reloadListenerFactory) {
        Objects.requireNonNull(identifier, "id is null");
        Objects.requireNonNull(reloadListenerFactory, "reload listener factory is null");
        this.registerReloadListenerFactory(identifier, reloadListenerFactory);
    }

    @Override
    public void registerReloadListener(class_2960 identifier, class_2960 otherResourceLocation, DataPackReloadListenersContext.PreparableReloadListenerFactory reloadListenerFactory) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(otherResourceLocation, "other identifier is null");
        Objects.requireNonNull(reloadListenerFactory, "reload listener factory is null");
        if (VANILLA_SERVER_RELOAD_LISTENERS.containsKey(identifier)) {
            this.registerReloadListenerFactory(otherResourceLocation, reloadListenerFactory);
            DataResourceLoader.get().addReloaderOrdering(VANILLA_SERVER_RELOAD_LISTENERS.get(identifier), otherResourceLocation);
        } else if (VANILLA_SERVER_RELOAD_LISTENERS.containsKey(otherResourceLocation)) {
            this.registerReloadListenerFactory(identifier, reloadListenerFactory);
            DataResourceLoader.get().addReloaderOrdering(identifier, VANILLA_SERVER_RELOAD_LISTENERS.get(otherResourceLocation));
        } else {
            throw new RuntimeException("Unknown reload listeners: " + String.valueOf(identifier) + ", " + String.valueOf(otherResourceLocation));
        }
    }

    private void registerReloadListenerFactory(class_2960 identifier, DataPackReloadListenersContext.PreparableReloadListenerFactory reloadListenerFactory) {
        DataResourceLoader.get().registerReloader(identifier, registries -> {
            class_5350 reloadableServerResources = (class_5350)RELOADABLE_SERVER_RESOURCES_REFERENCE.get().get();
            Objects.requireNonNull(reloadableServerResources, "reloadable server resources is null");
            return reloadListenerFactory.apply(reloadableServerResources, (class_7225.class_7874)registries);
        });
    }
}

