/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.util.v1;

import fuzs.puzzleslib.impl.chat.StyleCombiningCharSink;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public final class ComponentHelper {
    private ComponentHelper() {
    }

    public static class_2561 getAsComponent(String string) {
        Objects.requireNonNull(string, "string is null");
        return ComponentHelper.getAsComponent(class_5348.method_29430((String)string));
    }

    public static class_2561 getAsComponent(class_5348 formattedText) {
        return (class_2561)ComponentHelper.iterate(formattedText, StyleCombiningCharSink::getAsComponent);
    }

    public static String getAsString(class_5348 formattedText) {
        return (String)ComponentHelper.iterate(formattedText, StyleCombiningCharSink::getAsString);
    }

    public static class_2561 getAsComponent(class_5481 formattedCharSequence) {
        return (class_2561)ComponentHelper.iterate(formattedCharSequence, StyleCombiningCharSink::getAsComponent);
    }

    public static String getAsString(class_5481 formattedCharSequence) {
        return (String)ComponentHelper.iterate(formattedCharSequence, StyleCombiningCharSink::getAsString);
    }

    private static <T> T iterate(class_5348 formattedText, StyleCombiningCharSink.FormattedContentComposer<T> formattedContentComposer) {
        Objects.requireNonNull(formattedText, "formatted text is null");
        StyleCombiningCharSink styleCombiningCharSink = new StyleCombiningCharSink();
        class_5223.method_27476((class_5348)formattedText, (class_2583)class_2583.field_24360, (class_5224)styleCombiningCharSink);
        return (T)formattedContentComposer.apply(styleCombiningCharSink);
    }

    private static <T> T iterate(class_5481 formattedCharSequence, StyleCombiningCharSink.FormattedContentComposer<T> formattedContentComposer) {
        Objects.requireNonNull(formattedCharSequence, "formatted char sequence is null");
        StyleCombiningCharSink styleCombiningCharSink = new StyleCombiningCharSink();
        formattedCharSequence.accept((class_5224)styleCombiningCharSink);
        return ComponentHelper.iterate((class_5348)styleCombiningCharSink.getAsComponent(), formattedContentComposer);
    }

    public static class_2583 getDefaultStyle(String string) {
        Objects.requireNonNull(string, "string is null");
        class_2561 component = ComponentHelper.getAsComponent(string);
        if (!string.isEmpty() && component.getString().isEmpty()) {
            int index = string.indexOf(class_124.field_1070.toString());
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.insert(index != -1 ? index : string.length(), " ");
            return ComponentHelper.getAsComponent(stringBuilder.toString()).method_10866();
        }
        return component.method_10866();
    }

    public static class_2583 getDefaultStyle(class_5348 formattedText) {
        return ComponentHelper.getAsComponent(formattedText).method_10866();
    }

    public static class_2583 getDefaultStyle(class_5481 formattedCharSequence) {
        return ComponentHelper.getAsComponent(formattedCharSequence).method_10866();
    }

    public static String getAsString(class_2583 style) {
        Objects.requireNonNull(style, "style is null");
        if (style.method_10967()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ComponentHelper.getLegacyFormat(style, chatFormatting -> stringBuilder.append(chatFormatting.toString()));
        return stringBuilder.toString();
    }

    public static void getLegacyFormat(class_2583 style, Consumer<class_124> chatFormattingConsumer) {
        class_124 color;
        Objects.requireNonNull(style, "style is null");
        if (style.method_10967()) {
            return;
        }
        if (style.method_10973() != null && (color = class_124.method_533((String)style.method_10973().method_27721())) != null) {
            chatFormattingConsumer.accept(color);
        }
        if (style.method_10984()) {
            chatFormattingConsumer.accept(class_124.field_1067);
        }
        if (style.method_10966()) {
            chatFormattingConsumer.accept(class_124.field_1056);
        }
        if (style.method_10965()) {
            chatFormattingConsumer.accept(class_124.field_1073);
        }
        if (style.method_10986()) {
            chatFormattingConsumer.accept(class_124.field_1055);
        }
        if (style.method_10987()) {
            chatFormattingConsumer.accept(class_124.field_1051);
        }
    }

    public static class_2583 sanitizeLegacyFormat(class_2583 style) {
        Objects.requireNonNull(style, "style is null");
        if (style.method_10967()) {
            return style;
        }
        if (!style.method_10984()) {
            style = style.method_10982(null);
        }
        if (!style.method_10966()) {
            style = style.method_10978(null);
        }
        if (!style.method_10965()) {
            style = style.method_30938(null);
        }
        if (!style.method_10986()) {
            style = style.method_36140(null);
        }
        if (!style.method_10987()) {
            style = style.method_36141(null);
        }
        return style;
    }
}

