/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.tooltip;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import net.xstopho.resource_backpacks.backpack.component.BackpackContainerContents;
import net.xstopho.resource_backpacks.backpack.tooltip.BaseClientTooltipComponent;
import net.xstopho.resource_backpacks.backpack.util.BackpackLevel;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;

public class CompactClientTooltipComponent
extends BaseClientTooltipComponent {
    private final List<BaseClientTooltipComponent.StackHolder> items;

    public CompactClientTooltipComponent(CompactTooltipComponent component) {
        List<class_1799> itemList = component.content().toList();
        if (component.level.equals((Object)BackpackLevel.END)) {
            class_1657 player = BackpackClientUtils.getPlayer();
            itemList = this.getEnderChestItems(player);
        }
        this.items = this.getCompactItemList(itemList);
    }

    @Override
    public void renderPreview(class_327 font, int x, int y, class_332 guiGraphics) {
        int xOffset = 0;
        int yOffset = 0;
        for (BaseClientTooltipComponent.StackHolder holder : this.items) {
            this.renderDecoratedItem(font, holder.getStack(), holder.getCount(), x + xOffset, y + yOffset, guiGraphics);
            if ((xOffset += 18) != this.method_32664(font)) continue;
            xOffset = 0;
            yOffset += 18;
        }
    }

    public int method_32661(class_327 font) {
        if (!this.items.isEmpty()) {
            return (int)Math.ceil((double)this.items.size() / 10.0) * 18;
        }
        return 0;
    }

    public int method_32664(class_327 font) {
        return this.items.size() < 10 ? this.items.size() * 18 : 180;
    }

    private List<BaseClientTooltipComponent.StackHolder> getCompactItemList(List<class_1799> items) {
        ArrayList<BaseClientTooltipComponent.StackHolder> holderList = new ArrayList<BaseClientTooltipComponent.StackHolder>();
        for (class_1799 stack : items) {
            boolean combined = false;
            if (stack.method_7960()) continue;
            for (BaseClientTooltipComponent.StackHolder holder : holderList) {
                if (stack.method_7909() != holder.getItem() || stack.method_7963()) continue;
                combined = holder.combine(stack);
            }
            if (combined) continue;
            holderList.add(new BaseClientTooltipComponent.StackHolder(stack));
        }
        holderList.sort(Comparator.comparingInt(BaseClientTooltipComponent.StackHolder::getCount));
        return holderList.reversed();
    }

    public record CompactTooltipComponent(BackpackContainerContents content, BackpackLevel level) implements class_5632
    {
    }
}

