/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_backpacks.backpack.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import net.xstopho.resource_backpacks.client.util.BackpackClientUtils;
import net.xstopho.resource_backpacks.registries.KeyMappingRegistry;

public final class BackpackContainerContents
implements class_9299 {
    public static final Codec<BackpackContainerContents> CODEC = BackpackSlot.CODEC.sizeLimitedListOf(256).xmap(BackpackContainerContents::fromSlots, BackpackContainerContents::asSlots);
    public static final class_9139<class_9129, BackpackContainerContents> STREAM_CODEC = class_1799.field_49268.method_56433(class_9135.method_58000((int)256)).method_56432(BackpackContainerContents::new, BackpackContainerContents::toList);
    public static final BackpackContainerContents EMPTY = new BackpackContainerContents((List<class_1799>)class_2371.method_10211());
    private final class_2371<class_1799> items;
    private final int hashCode;

    public BackpackContainerContents(List<class_1799> items) {
        if (items.size() > 256) {
            throw new IllegalArgumentException("Too many items, max is 256");
        }
        this.items = class_2371.method_10213((int)items.size(), (Object)class_1799.field_8037);
        this.hashCode = class_1799.method_57361(items);
        for (int index = 0; index < items.size(); ++index) {
            this.items.set(index, (Object)items.get(index));
        }
    }

    private static BackpackContainerContents fromSlots(List<BackpackSlot> slots) {
        OptionalInt optional = slots.stream().mapToInt(BackpackSlot::index).max();
        BackpackContainerContents component = EMPTY;
        if (optional.isPresent()) {
            component = new BackpackContainerContents((List<class_1799>)class_2371.method_10213((int)(optional.getAsInt() + 1), (Object)class_1799.field_8037));
            for (BackpackSlot slot : slots) {
                component.items.set(slot.index(), (Object)slot.stack());
            }
        }
        return component;
    }

    private List<BackpackSlot> asSlots() {
        ArrayList<BackpackSlot> slots = new ArrayList<BackpackSlot>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            slots.add(new BackpackSlot(i, (class_1799)this.items.get(i)));
        }
        return slots;
    }

    public List<class_1799> toList() {
        return this.items.stream().map(class_1799::method_7972).toList();
    }

    public void copyInto(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            class_1799 stack = class_1799.field_8037;
            if (i < this.items.size()) {
                stack = (class_1799)this.items.get(i);
            }
            list.set(i, (Object)stack.method_7972());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BackpackContainerContents) {
            BackpackContainerContents container = (BackpackContainerContents)other;
            return class_1799.method_57362(this.items, container.items);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void method_57409(class_1792.class_9635 tooltipContext, Consumer<class_2561> consumer, class_1836 tooltipFlag, class_9473 dataComponentGetter) {
        if (!BackpackClientUtils.enableCompactPreview() && !BackpackClientUtils.enableInventoryPreview()) {
            if (!KeyMappingRegistry.SHOW_COMPACT_PREVIEW.method_1415()) {
                consumer.accept((class_2561)KeyMappingRegistry.SHOW_COMPACT_PREVIEW.method_16007().method_27661().method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.resource_backpacks.info.compact_preview").method_27692(class_124.field_1068)));
            }
            if (!KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.method_1415()) {
                consumer.accept((class_2561)KeyMappingRegistry.SHOW_INVENTORY_PREVIEW.method_16007().method_27661().method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)"tooltip.resource_backpacks.info.inventory_preview").method_27692(class_124.field_1068)));
            }
        }
    }

    record BackpackSlot(int index, class_1799 stack) {
        public static final Codec<BackpackSlot> CODEC = RecordCodecBuilder.create(slot -> slot.group((App)Codec.intRange((int)0, (int)256).fieldOf("slot").forGetter(BackpackSlot::index), (App)class_1799.field_24671.fieldOf("item").forGetter(BackpackSlot::stack)).apply((Applicative)slot, BackpackSlot::new));
    }
}

