/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;

public class PlayerFunctions {
    public static boolean respawnPlayer(Level world, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverplayer = (ServerPlayer)player;
        MinecraftServer server = world.getServer();
        if (serverplayer.wonGame) {
            serverplayer.wonGame = false;
            serverplayer = server.getPlayerList().respawn(serverplayer, true, Entity.RemovalReason.CHANGED_DIMENSION);
            CriteriaTriggers.CHANGED_DIMENSION.trigger(serverplayer, Level.END, Level.OVERWORLD);
        } else if (serverplayer.getHealth() <= 0.0f) {
            server.getPlayerList().respawn(serverplayer, false, Entity.RemovalReason.KILLED);
        }
        return true;
    }

    public static Player matchPlayer(Player player, String other) {
        return PlayerFunctions.matchPlayer(player.level(), other);
    }

    public static Player matchPlayer(Level world, String other) {
        List players = world.players();
        for (Player onlineplayer : players) {
            if (!onlineplayer.getName().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(Player player) {
        return player.getItemInHand(InteractionHand.OFF_HAND).getItem().equals(Items.WATER_BUCKET) || player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(Items.WATER_BUCKET);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory) {
        return PlayerFunctions.isJoiningWorldForTheFirstTime(player, modid, false, true);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid, boolean mustHaveEmptyInventory, boolean mustBeCloseToSpawn) {
        String firstjointag = "collective.firstJoin." + modid;
        String playerName = player.getName().getString();
        Set tags = player.getTags();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.addTag(firstjointag);
        if (mustHaveEmptyInventory) {
            Inventory inv = player.getInventory();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                if (inv.getItem(i).isEmpty()) continue;
                isempty = false;
                break;
            }
            if (!isempty) {
                Constants.LOG.debug("[{}] Inventory of {} is not empty, first join is false.", (Object)modid, (Object)playerName);
                return false;
            }
        }
        if (mustBeCloseToSpawn) {
            Level level = player.level();
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LevelData.RespawnData respawnData = serverLevel.getRespawnData();
            GlobalPos globalSpawnPos = respawnData.globalPos();
            ResourceKey spawnDimension = globalSpawnPos.dimension();
            BlockPos spawnPos = globalSpawnPos.pos();
            ServerPlayer.RespawnConfig respawnConfig = serverPlayer.getRespawnConfig();
            if (respawnConfig != null) {
                LevelData.RespawnData respawnConfigRespawnData = respawnConfig.respawnData();
                spawnDimension = respawnConfigRespawnData.dimension();
                spawnPos = respawnConfigRespawnData.pos();
            }
            Constants.LOG.debug("[{}] Checking for first join of {} with spawn position: {}", new Object[]{modid, playerName, spawnPos.toShortString()});
            if (!spawnDimension.equals(player.level().dimension())) {
                return false;
            }
            BlockPos playerPos = player.blockPosition();
            BlockPos checkPos = new BlockPos(playerPos.getX(), spawnPos.getY(), playerPos.getZ());
            int spawnRadius = (Integer)serverLevel.getGameRules().get(GameRules.RESPAWN_RADIUS);
            Constants.LOG.debug("[{}] Checking for first join of {} with spawn radius: {}", new Object[]{modid, playerName, spawnRadius});
            return checkPos.closerThan((Vec3i)spawnPos, (double)(spawnRadius * 2));
        }
        return true;
    }

    public static BlockPos getSpawnPoint(Level level, Player player) {
        Vec3 spawnvec = PlayerFunctions.getSpawnVec(level, player);
        return BlockPos.containing((double)spawnvec.x, (double)spawnvec.y, (double)spawnvec.z);
    }

    public static Vec3 getSpawnVec(Level level, Player player) {
        ServerPlayer serverplayer = (ServerPlayer)player;
        ServerLevel serverLevel = (ServerLevel)level;
        LevelData.RespawnData respawnData = serverLevel.getRespawnData();
        GlobalPos globalRespawnPos = respawnData.globalPos();
        BlockPos respawnlocation = globalRespawnPos.pos();
        Vec3 respawnvec = new Vec3((double)respawnlocation.getX(), (double)respawnlocation.getY(), (double)respawnlocation.getZ());
        BlockPos bedpos = serverplayer.getRespawnConfig().respawnData().pos();
        if (bedpos != null) {
            TeleportTransition optionalbed = ((ServerPlayer)player).findRespawnPositionAndUseSpawnBlock(true, TeleportTransition.DO_NOTHING);
            Vec3 bedvec = optionalbed.position();
            BlockPos bp = BlockPos.containing((Position)bedvec);
            Iterator it = BlockPos.betweenClosedStream((int)(bp.getX() - 1), (int)(bp.getY() - 1), (int)(bp.getZ() - 1), (int)(bp.getX() + 1), (int)(bp.getY() + 1), (int)(bp.getZ() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = level.getBlockState(np);
                Block block = state.getBlock();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static InteractionHand getOtherHand(InteractionHand hand) {
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    public static String getPlayerGearString(Player player) {
        Level level = player.level();
        StringBuilder skconfig = new StringBuilder();
        ItemStack offhand = player.getItemBySlot(EquipmentSlot.OFFHAND);
        if (!offhand.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, offhand);
            skconfig.append("'offhand' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("'offhand' : '',");
        }
        ItemStack head = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!head.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, head);
            skconfig.append("\n'head' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'head' : '',");
        }
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!chest.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, chest);
            skconfig.append("\n'chest' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'chest' : '',");
        }
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        if (!legs.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, legs);
            skconfig.append("\n'legs' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'legs' : '',");
        }
        ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
        if (!feet.isEmpty()) {
            String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, feet);
            skconfig.append("\n'feet' : '").append(nbtstring).append("',");
        } else {
            skconfig.append("\n'feet' : '',");
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.getItem(i);
            if (!slot.isEmpty()) {
                String nbtstring = ItemFunctions.getNBTStringFromItemStack(level, slot);
                skconfig.append("\n").append(i).append(" : ").append("'").append(nbtstring).append("',");
                continue;
            }
            skconfig.append("\n").append(i).append(" : '',");
        }
        return skconfig.toString();
    }

    public static String getPlayerGearStringFromHashMap(Level level, HashMap<String, ItemStack> gear) {
        StringBuilder gearstring = new StringBuilder();
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                specialslotstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get(specialslot));
            }
            if (!gearstring.toString().isEmpty()) {
                gearstring.append("\n");
            }
            gearstring.append("'").append(specialslot).append("'").append(" : ").append("'").append(specialslotstring).append("',");
        }
        NonNullList emptyinventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                itemstring = ItemFunctions.getNBTStringFromItemStack(level, gear.get("" + i));
            }
            gearstring.append("\n").append(i).append(" : '").append(itemstring).append("',");
        }
        return gearstring.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void setPlayerGearFromString(Player player, String gearconfig) {
        Level level = player.level();
        String[] gearspl = gearconfig.split("',[\\r\\n]+");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        block18: for (String string : gearspl) {
            EquipmentSlot type;
            void var9_9;
            String[] lspl;
            void var9_13;
            String string2 = string.trim();
            if (string2.endsWith(",")) {
                String string3 = string2.substring(0, string2.length() - 1);
            }
            if (!var9_13.endsWith("'")) {
                String string4 = (String)var9_13 + "'";
            }
            if ((lspl = var9_9.split(" : ")).length != 2) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: The line {} is invalid.", (Object)var9_9);
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if (data.startsWith("'")) {
                data = data.substring(1);
            }
            if (data.endsWith("'")) {
                data = data.substring(0, data.length() - 1);
            }
            if (data.length() < 2) continue;
            data = data.replaceAll("\r", "");
            ItemStack itemStack = ItemStack.EMPTY;
            try {
                CompoundTag compoundTag2 = TagParser.parseCompoundFully((String)data);
                itemStack = ItemStack.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag2).result().orElse(ItemStack.EMPTY);
            }
            catch (CommandSyntaxException compoundTag2) {
                // empty catch block
            }
            if (itemStack.isEmpty()) {
                try {
                    data = data.replace("\",\"", "|||,|||").replace(" \"", " '").replace("\" ", "' ").replace("|||,|||", "\",\"");
                    CompoundTag compoundTag = TagParser.parseCompoundFully((String)data);
                    itemStack = ItemStack.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).result().orElse(ItemStack.EMPTY);
                }
                catch (CommandSyntaxException ex) {
                    ex.printStackTrace();
                }
            }
            if (itemStack.isEmpty()) {
                Constants.LOG.info("[Error] (Collective) setPlayerGearFromString: Unable to get the correct itemstack data from data {}", (Object)data);
                return;
            }
            if (!cleared) {
                cleared = true;
                player.getInventory().clearContent();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.getInventory().setItem(slot, itemStack);
                continue;
            }
            switch (slotstring) {
                case "offhand": {
                    type = EquipmentSlot.OFFHAND;
                    break;
                }
                case "head": {
                    type = EquipmentSlot.HEAD;
                    break;
                }
                case "chest": {
                    type = EquipmentSlot.CHEST;
                    break;
                }
                case "legs": {
                    type = EquipmentSlot.LEGS;
                    break;
                }
                case "feet": {
                    type = EquipmentSlot.FEET;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            player.setItemSlot(type, itemStack);
        }
    }
}

