/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.ingredients;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.util.MathUtil;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.joml.Matrix3x2fStack;

public class TagContentTooltipComponent<T>
implements class_5684,
class_5632 {
    private static final int MAX_PER_LINE = 10;
    private static final int MAX_LINES = 3;
    private static final int MAX_INGREDIENTS = 30;
    private static final int INGREDIENT_SIZE = 18;
    private static final int INGREDIENT_PADDING = 1;
    private final IIngredientRenderer<T> renderer;
    private final List<T> ingredients;

    public TagContentTooltipComponent(IIngredientRenderer<T> renderer, List<T> ingredients) {
        this.renderer = renderer;
        this.ingredients = ingredients;
    }

    public void method_32666(class_327 font, int x, int y, int p_368529_, int p_368584_, class_332 guiGraphics) {
        if (this.ingredients.size() <= 30) {
            this.drawIngredients(guiGraphics, x, y, this.ingredients.size());
        } else {
            int drawCount = 29;
            this.drawIngredients(guiGraphics, x, y, 29);
            if (this.ingredients.size() > 30) {
                int remainingCount = Math.min(this.ingredients.size() - 29, 99);
                String countString = "+" + remainingCount;
                Objects.requireNonNull(font);
                int textHeight = 9 - 1;
                int textWidth = font.method_1727(countString);
                int textCenterX = x + 162 + (18 - textWidth) / 2;
                int textCenterY = y + 36 + (18 - textHeight) / 2;
                guiGraphics.method_25303(font, countString, textCenterX, textCenterY, 0xAAAAAA);
            }
        }
    }

    private void drawIngredients(class_332 guiGraphics, int x, int y, int maxIngredients) {
        int maxPerLine = MathUtil.divideCeil(maxIngredients, this.getLineCount());
        for (int i = 0; i < this.ingredients.size() && i < maxIngredients; ++i) {
            int column = i % maxPerLine;
            int row = i / maxPerLine;
            Matrix3x2fStack poseStack = guiGraphics.method_51448();
            poseStack.pushMatrix();
            poseStack.translate((float)(x + column * 18 + 1), (float)(y + row * 18 + 1));
            this.renderer.render(guiGraphics, this.ingredients.get(i));
            poseStack.popMatrix();
        }
    }

    private int getLineCount() {
        int lineCount = MathUtil.divideCeil(this.ingredients.size(), 10);
        return Math.min(lineCount, 3);
    }

    private int getMaxPerLine() {
        int perLine = MathUtil.divideCeil(this.ingredients.size(), this.getLineCount());
        return Math.min(perLine, 10);
    }

    public int method_32661(class_327 font) {
        return this.getLineCount() * 18 + 2;
    }

    public int method_32664(class_327 font) {
        return this.getMaxPerLine() * 18 + 2;
    }
}

