/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IIngredientGrid;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IIngredientGrid ingredientGrid;
    private final IClientToggleState toggleState;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;
    private final IIngredientManager ingredientManager;

    public DeleteItemInputHandler(IIngredientGrid ingredientGrid, IClientToggleState toggleState, IClientConfig clientConfig, IConnectionToServer serverConnection, IIngredientManager ingredientManager) {
        this.ingredientGrid = ingredientGrid;
        this.toggleState = toggleState;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, IGuiProperties guiProperties, UserInput userInput, IInternalKeyMappings keyBindings) {
        double mouseY;
        if (!userInput.is(keyBindings.getLeftClick())) {
            return Optional.empty();
        }
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        class_310 minecraft = class_310.method_1551();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return Optional.empty();
        }
        class_1799 itemStack = player.field_7512.method_34255();
        if (itemStack.method_7960()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.field_7512.method_34254(class_1799.field_8037);
            if (!(player.field_7512 instanceof class_481.class_483)) {
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                this.serverConnection.sendPacketToServer(packet);
            }
        }
        return Optional.of(this);
    }

    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        JeiTooltip tooltip = new JeiTooltip();
        tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.delete.item"));
        tooltip.draw(guiGraphics, mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(class_310 minecraft, double mouseX, double mouseY) {
        if (!this.toggleState.isCheatItemsEnabled() || !this.serverConnection.isJeiOnServer()) {
            return false;
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return false;
        }
        class_1799 itemStack = player.field_7512.method_34255();
        if (itemStack.method_7960()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(c -> c.getCheatItemStack(this.ingredientManager)).map(i -> !ServerCommandUtil.canStack(itemStack, i)).orElse(true);
        }
        return true;
    }
}

