/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen.namegen;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.event.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.worldgen.namegen.BiomeNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.CustomNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MixedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.MrPorkNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.RomanNumber;
import net.blay09.mods.waystones.worldgen.namegen.SequencedNameGenerator;
import net.blay09.mods.waystones.worldgen.namegen.TemplateNameGenerator;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class NameGeneratorManager
extends class_18 {
    private static final String DATA_NAME = "waystones_name_generator";
    private static final Codec<NameGeneratorManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("UsedNames").forGetter(NameGeneratorManager::getUsedNames)).apply((Applicative)instance, NameGeneratorManager::new));
    public static final class_10741<NameGeneratorManager> TYPE = new class_10741("waystones_name_generator", () -> new NameGeneratorManager(List.of()), CODEC, null);
    private final Set<String> usedNames = Sets.newHashSet();

    public NameGeneratorManager(List<String> usedNames) {
        this.usedNames.addAll(usedNames);
    }

    public static NameGeneratorManager get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        return (NameGeneratorManager)Objects.requireNonNull(overworld).method_17983().method_17924(TYPE);
    }

    public List<String> getUsedNames() {
        return new ArrayList<String>(this.usedNames);
    }

    private NameGenerator getNameGenerator(NameGenerationMode nameGenerationMode) {
        TemplateNameGenerator randomGenerator = new TemplateNameGenerator(WaystonesConfig.getActive().worldGen.nameGenerationTemplate).with("MrPork", new MrPorkNameGenerator()).with("Biome", new BiomeNameGenerator());
        switch (nameGenerationMode) {
            case MIXED: {
                return new MixedNameGenerator(randomGenerator, new CustomNameGenerator(false, this.usedNames));
            }
            case RANDOM_ONLY: {
                return randomGenerator;
            }
            case PRESET_ONLY: {
                return new CustomNameGenerator(true, this.usedNames);
            }
        }
        return new SequencedNameGenerator(new CustomNameGenerator(false, this.usedNames), randomGenerator);
    }

    public synchronized class_2561 getName(class_1936 level, Waystone waystone, class_5819 rand, NameGenerationMode nameGenerationMode) {
        NameGenerator nameGenerator = this.getNameGenerator(nameGenerationMode);
        class_2561 originalName = nameGenerator.generateName(level, waystone, rand).orElse((class_2561)class_2561.method_43473());
        class_2561 name = this.resolveDuplicate(originalName);
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(waystone, name);
        ((Consumer)GenerateWaystoneNameEvent.EVENT.invoker()).accept(new GenerateWaystoneNameEvent(waystone, name));
        name = event.getName();
        this.usedNames.add(name.getString());
        this.method_80();
        return name;
    }

    private class_2561 resolveDuplicate(class_2561 name) {
        class_2561 tryName = name;
        int i = 1;
        while (this.usedNames.contains(tryName.getString())) {
            tryName = name.method_27661().method_27693(" " + RomanNumber.toRoman(i));
            ++i;
        }
        return tryName;
    }
}

