/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.message.ClientboundKnownWaystonesPacket;
import net.blay09.mods.waystones.network.message.ClientboundPlayerWaystoneCooldownsPacket;
import net.blay09.mods.waystones.network.message.ClientboundSortingIndexPacket;
import net.blay09.mods.waystones.network.message.ClientboundUpdateWaystonePacket;
import net.blay09.mods.waystones.network.message.ClientboundWaystoneRemovedPacket;
import net.blay09.mods.waystones.store.SavedDataWaystonesStore;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(@Nullable MinecraftServer server, Waystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }

    public static void sendWaystoneRemovalToAll(@Nullable MinecraftServer server, Waystone waystone, boolean wasDestroyed) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            WaystoneSyncManager.sendWaystoneRemoval((class_1657)player, waystone, wasDestroyed);
        }
    }

    public static void sendSortingIndex(class_1657 player) {
        List<UUID> sortingIndex = PlayerWaystoneManager.getSortingIndex(player);
        Balm.networking().sendTo(player, (class_8710)new ClientboundSortingIndexPacket(sortingIndex));
    }

    public static void sendActivatedWaystones(class_1657 player) {
        ArrayList<Waystone> waystones = new ArrayList<Waystone>(PlayerWaystoneManager.getActivatedWaystones(player));
        Balm.networking().sendTo(player, (class_8710)new ClientboundKnownWaystonesPacket(WaystoneTypes.WAYSTONE, waystones));
    }

    public static void sendWaystonesOfType(class_2960 waystoneType, class_3222 player) {
        ArrayList<Waystone> warpPlates = new ArrayList<Waystone>(SavedDataWaystonesStore.get(player.method_51469().method_8503()).getWaystonesByType(waystoneType));
        Balm.networking().sendTo((class_1657)player, (class_8710)new ClientboundKnownWaystonesPacket(waystoneType, warpPlates));
    }

    public static void sendWaystoneUpdate(class_1657 player, Waystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.networking().sendTo(player, (class_8710)new ClientboundUpdateWaystonePacket(waystone));
        }
    }

    public static void sendWaystoneRemoval(class_1657 player, Waystone waystone, boolean wasDestroyed) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.networking().sendTo(player, (class_8710)new ClientboundWaystoneRemovedPacket(waystone.getWaystoneType(), waystone.getWaystoneUid(), wasDestroyed));
        }
    }

    public static void sendWaystoneCooldowns(class_1657 player) {
        Map<class_2960, Long> cooldowns = PlayerWaystoneManager.getCooldowns(player);
        Balm.networking().sendTo(player, (class_8710)new ClientboundPlayerWaystoneCooldownsPacket(cooldowns));
    }
}

