/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.waystones.api.MutableWaystone;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneOrigin;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.error.WaystoneTeleportError;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.component.WaystoneReferenceComponent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.network.message.ClientboundWarpPlateEjectEffectPacket;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGeneratorManager;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase {
    private final WeakHashMap<class_1297, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private int nextRoundRobinAttunementSlot;
    protected int attunementTicks;

    public WarpPlateBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.warpPlate.comp_349(), blockPos, blockState);
    }

    @Override
    protected void onInventoryChanged() {
        if (this.field_11863 != null) {
            this.field_11863.method_8652(this.field_11867, this.getIdleState(), 3);
        }
    }

    @Override
    public void initializeWaystone(class_5425 level, @Nullable class_1309 player, WaystoneOrigin origin) {
        super.initializeWaystone(level, player, origin);
        Waystone waystone = this.getWaystone();
        if (waystone instanceof MutableWaystone) {
            class_2561 name = NameGeneratorManager.get(level.method_8410().method_8503()).getName((class_1936)level, waystone, level.method_8409(), NameGenerationMode.RANDOM_ONLY);
            ((MutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(level.method_8503(), waystone);
        this.initializeInventory();
    }

    private void initializeInventory() {
        this.setShardItem(ModItems.dormantShard.createStack());
    }

    @Override
    protected class_2960 getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("LastAttunementSlot", this.nextRoundRobinAttunementSlot);
    }

    @Override
    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.nextRoundRobinAttunementSlot = input.method_71424("LastAttunementSlot", 0);
    }

    public boolean hasPotentialWarpTarget() {
        class_1799 shardItem = this.getShardItem();
        return !shardItem.method_7960() && !shardItem.method_41406((class_6880)ModItems.deepslateShard);
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43471((String)"container.waystones.warp_plate");
    }

    public void onEntityCollision(class_1297 entity) {
        if (WaystonePermissionManager.isEntityDeniedTeleports(entity)) {
            return;
        }
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if ((ticksPassed == null || ticksPassed != -1) && this.hasPotentialWarpTarget()) {
            Waystone targetWaystone = this.getTargetWaystone().orElse(InvalidWaystone.INSTANCE);
            WarpPlateBlock.WarpPlateStatus status = targetWaystone.isValid() ? WarpPlateBlock.WarpPlateStatus.WARPING : WarpPlateBlock.WarpPlateStatus.WARPING_INVALID;
            Boolean canAfford = WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> it.setFromWaystone(this.getWaystone())).mapLeft(WaystoneTeleportContext::getRequirements).mapLeft(it -> {
                boolean bl;
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    if (!player.method_31549().field_7477 && !it.canAfford(player)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }).left().orElse(true);
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)(canAfford != false ? status : WarpPlateBlock.WarpPlateStatus.WARPING_INVALID))), 3);
        }
    }

    private boolean isEntityOnWarpPlate(class_1297 entity) {
        return entity.method_23317() >= (double)this.field_11867.method_10263() && entity.method_23317() < (double)(this.field_11867.method_10263() + 1) && entity.method_23318() >= (double)this.field_11867.method_10264() && entity.method_23318() < (double)(this.field_11867.method_10264() + 1) && entity.method_23321() >= (double)this.field_11867.method_10260() && entity.method_23321() < (double)(this.field_11867.method_10260() + 1);
    }

    public class_2680 getIdleState() {
        class_1799 shardItem = this.getShardItem();
        if (shardItem.method_7960()) {
            return (class_2680)this.method_11010().method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.EMPTY));
        }
        if (shardItem.method_41406((class_6880)ModItems.deepslateShard)) {
            return (class_2680)this.method_11010().method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.LOCKED));
        }
        if (shardItem.method_41406((class_6880)ModItems.dormantShard)) {
            return (class_2680)this.method_11010().method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.ATTUNING));
        }
        return (class_2680)this.method_11010().method_11657(WarpPlateBlock.STATUS, (Comparable)((Object)WarpPlateBlock.WarpPlateStatus.IDLE));
    }

    public void serverTick() {
        class_238 boundsAbove;
        List entities;
        this.attuneShard();
        WarpPlateBlock.WarpPlateStatus status = (WarpPlateBlock.WarpPlateStatus)((Object)this.method_11010().method_11654(WarpPlateBlock.STATUS));
        if ((status == WarpPlateBlock.WarpPlateStatus.WARPING || status == WarpPlateBlock.WarpPlateStatus.WARPING_INVALID) && (entities = this.field_11863.method_8333((class_1297)null, boundsAbove = new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1)), class_1301.field_6154)).isEmpty()) {
            this.field_11863.method_8652(this.field_11867, this.getIdleState(), 3);
            this.ticksPassedPerEntity.clear();
        }
        if (this.hasPotentialWarpTarget()) {
            int useTime = this.getWarpPlateUseTime();
            Iterator<Map.Entry<class_1297, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_1297, Integer> entry = iterator.next();
                class_1297 entity = entry.getKey();
                Integer ticksPassed = entry.getValue();
                if (!entity.method_5805() || !this.isEntityOnWarpPlate(entity)) {
                    iterator.remove();
                    continue;
                }
                if (ticksPassed > useTime) {
                    class_1799 targetAttunementStack = this.getTargetAttunementStack();
                    ++this.nextRoundRobinAttunementSlot;
                    Waystone targetWaystone = WaystonesAPI.getBoundWaystone(null, targetAttunementStack).orElse(null);
                    if (targetWaystone != null && targetWaystone.isValid()) {
                        this.teleportToTarget(entity, targetWaystone, targetAttunementStack);
                    }
                    if (entity instanceof class_1657) {
                        if (targetWaystone == null) {
                            chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_no_target");
                            chatComponent.method_27692(class_124.field_1079);
                            ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                        } else if (!targetWaystone.isValid()) {
                            chatComponent = class_2561.method_43471((String)"chat.waystones.warp_plate_has_invalid_target");
                            chatComponent.method_27692(class_124.field_1079);
                            ((class_1657)entity).method_7353((class_2561)chatComponent, true);
                        }
                    }
                    iterator.remove();
                    continue;
                }
                if (ticksPassed == -1) continue;
                entry.setValue(ticksPassed + 1);
            }
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_7909() == class_1802.field_27063) {
                useTimeMultiplier -= 0.016f * (float)itemStack.method_7947();
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8777) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.method_7947();
        }
        int configuredUseTime = WaystonesConfig.getActive().general.warpPlateUseTime;
        return class_3532.method_15340((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToTarget(class_1297 entity, Waystone targetWaystone, class_1799 targetAttunementStack) {
        WaystonesAPI.createDefaultTeleportContext(entity, targetWaystone, it -> {
            it.setFromWaystone(this.getWaystone());
            it.setWarpItem(targetAttunementStack);
        }).flatMap(WaystonesAPI::tryTeleport).ifRight(this.informRejectedTeleport(entity)).ifLeft(entities -> {
            block2: {
                block3: {
                    if (!targetAttunementStack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS)) break block2;
                    if (!(entity instanceof class_1657)) break block3;
                    class_1657 player = (class_1657)entity;
                    if (player.method_31549().field_7477) break block2;
                }
                targetAttunementStack.method_7934(1);
            }
        }).left();
    }

    private Consumer<WaystoneTeleportError> informRejectedTeleport(class_1297 entityToInform) {
        return error -> {
            if (error.getComponent() != null && entityToInform instanceof class_1657) {
                class_1657 player = (class_1657)entityToInform;
                class_5250 chatComponent = error.getComponent().method_27661().method_27692(class_124.field_1079);
                player.method_7353((class_2561)chatComponent, true);
            }
        };
    }

    public class_1799 getTargetAttunementStack() {
        boolean shouldRoundRobin = false;
        boolean shouldPrioritizeSingleUseShards = false;
        ArrayList<class_1799> attunedShards = new ArrayList<class_1799>();
        for (int i = 0; i < this.container.method_5439(); ++i) {
            class_1799 itemStack = this.container.method_5438(i);
            if (itemStack.method_31573(ModItemTags.WARP_SHARDS)) {
                Waystone waystoneAttunedTo = WaystonesAPI.getBoundWaystone(null, itemStack).orElse(null);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.method_7909() == class_1802.field_8155) {
                shouldRoundRobin = true;
                continue;
            }
            if (itemStack.method_7909() != class_1802.field_8680) continue;
            shouldPrioritizeSingleUseShards = true;
        }
        if (shouldPrioritizeSingleUseShards && attunedShards.stream().anyMatch(stack -> stack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS))) {
            attunedShards.removeIf(stack -> !stack.method_31573(ModItemTags.SINGLE_USE_WARP_SHARDS));
        }
        if (!attunedShards.isEmpty()) {
            this.nextRoundRobinAttunementSlot %= attunedShards.size();
            return shouldRoundRobin ? (class_1799)attunedShards.get(this.nextRoundRobinAttunementSlot) : (class_1799)attunedShards.get(this.random.nextInt(attunedShards.size()));
        }
        return class_1799.field_8037;
    }

    public Optional<Waystone> getTargetWaystone() {
        return WaystonesAPI.getBoundWaystone(null, this.getTargetAttunementStack());
    }

    public void markEntityForCooldown(class_1297 entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public void setShardItem(class_1799 itemStack) {
        this.container.method_5447(0, itemStack);
        if (this.field_11863 != null) {
            this.field_11863.method_8652(this.field_11867, this.getIdleState(), 3);
        }
        this.method_5431();
    }

    public class_1799 getShardItem() {
        return this.container.method_5438(0);
    }

    public void attuneShard() {
        class_1799 shardItem = this.getShardItem();
        if (shardItem.method_41406((class_6880)ModItems.dormantShard)) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                class_1799 attunedShard = ModItems.attunedShard.createStack();
                WaystonesAPI.setBoundWaystone(attunedShard, this.getWaystone());
                this.setShardItem(attunedShard);
            }
        } else if (this.field_11863 != null && shardItem.method_41406((class_6880)ModItems.attunedShard)) {
            WaystonesAPI.getBoundWaystone(null, shardItem).ifPresent(it -> {
                if (it.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) {
                    class_1542 shardEntity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, shardItem);
                    this.field_11863.method_8649((class_1297)shardEntity);
                    this.setShardItem(class_1799.field_8037);
                    class_1937 patt0$temp = this.field_11863;
                    if (patt0$temp instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)patt0$temp;
                        Balm.networking().sendToTracking(serverLevel, this.field_11867, (class_8710)new ClientboundWarpPlateEjectEffectPacket(this.field_11867));
                        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15219, class_3419.field_15248, 1.0f, 1.0f);
                    }
                }
            });
        } else {
            this.attunementTicks = 0;
        }
    }

    public int getMaxAttunementTicks() {
        return 30;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)ModComponents.waystoneIdentity.comp_349(), (Object)new WaystoneReferenceComponent(this.getEffectiveWaystoneUid(), WarpPlateBlock.getGalacticName(this.getWaystone().getWaystoneUid())));
    }
}

