/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import net.caffeinemc.mods.sodium.client.config.structure.BooleanOption;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class TickBoxControl
implements Control {
    private final BooleanOption option;

    public TickBoxControl(BooleanOption option) {
        this.option = option;
    }

    @Override
    public ControlElement createElement(class_437 screen, AbstractOptionList list, Dim2i dim, ColorTheme theme) {
        return new TickBoxControlElement(list, this.option, dim, theme);
    }

    @Override
    public int getMaxWidth() {
        return 30;
    }

    @Override
    public StatefulOption<Boolean> getOption() {
        return this.option;
    }

    private static class TickBoxControlElement
    extends ControlElement {
        private final BooleanOption option;

        public TickBoxControlElement(AbstractOptionList list, BooleanOption option, Dim2i dim, ColorTheme theme) {
            super(list, dim, theme);
            this.option = option;
        }

        @Override
        public Option getOption() {
            return this.option;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            if (!this.option.showControl()) {
                return;
            }
            int x = this.getLimitX() - 16;
            int y = this.getCenterY() - 5;
            int xEnd = x + 10;
            int yEnd = y + 10;
            boolean enabled = this.option.isEnabled();
            boolean ticked = (Boolean)this.option.getValidatedValue();
            int color = enabled ? (ticked ? this.theme.theme : -1) : -5592406;
            if (ticked) {
                this.drawRect(graphics, x + 2, y + 2, xEnd - 2, yEnd - 2, color);
            }
            if (enabled) {
                this.drawBorder(graphics, x, y, xEnd, yEnd, color);
            } else {
                int size = 3;
                graphics.method_25294(x, y, x + size, y + 1, color);
                graphics.method_25294(x, y, x + 1, y + size, color);
                graphics.method_25294(xEnd - size, y, xEnd, y + 1, color);
                graphics.method_25294(xEnd - 1, y, xEnd, y + size, color);
                graphics.method_25294(x, yEnd - 1, x + size, yEnd, color);
                graphics.method_25294(x, yEnd - size, x + 1, yEnd, color);
                graphics.method_25294(xEnd - size, yEnd - 1, xEnd, yEnd, color);
                graphics.method_25294(xEnd - 1, yEnd - size, xEnd, yEnd, color);
            }
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.option.isEnabled() && event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                this.toggleControl();
                return true;
            }
            return false;
        }

        public boolean method_25404(class_11908 event) {
            if (!this.method_25370()) {
                return false;
            }
            if (event.method_74229()) {
                this.toggleControl();
                return true;
            }
            return false;
        }

        private void toggleControl() {
            this.playClickSound();
            this.playClickSound();
            this.option.modifyValue((Boolean)this.option.getValidatedValue() == false);
        }
    }
}

