/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.FlagHook;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.client.config.builder.OptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.search.BigramSearchIndex;
import net.caffeinemc.mods.sodium.client.config.search.SearchIndex;
import net.caffeinemc.mods.sodium.client.config.search.SearchQuerySession;
import net.caffeinemc.mods.sodium.client.config.structure.BooleanOption;
import net.caffeinemc.mods.sodium.client.config.structure.EnumOption;
import net.caffeinemc.mods.sodium.client.config.structure.IntegerOption;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.structure.OptionGroup;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverlay;
import net.caffeinemc.mods.sodium.client.config.structure.OptionOverride;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.caffeinemc.mods.sodium.client.console.Console;
import net.caffeinemc.mods.sodium.client.console.message.MessageLevel;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class Config
implements ConfigState {
    private final Map<class_2960, Option> options = new Object2ReferenceLinkedOpenHashMap();
    private final Set<StorageEventHandler> pendingStorageHandlers = new ObjectOpenHashSet();
    private final List<ModOptions> modOptions;
    private final SearchIndex searchIndex = new BigramSearchIndex(this::registerSearchIndex);
    private final Collection<DynamicValue<?>> globalRebuildDependents = new ObjectArrayList();
    private final Map<class_2960, Collection<FlagHook>> flagHooks = new Object2ReferenceOpenHashMap();
    private final Set<FlagHook> triggeredHooks = new ObjectOpenHashSet();
    private static final Set<class_2960> SPECIAL_DEPENDENCIES = Set.of(ConfigState.UPDATE_ON_REBUILD, ConfigState.UPDATE_ON_APPLY);

    public Config(List<ModOptions> modOptions) {
        this.modOptions = Collections.unmodifiableList(modOptions);
        this.collectOptions();
        this.applyOptionChanges();
        this.collectApplyHooks();
        this.validateDependencies();
        for (Option option : this.options.values()) {
            option.loadValueInitial();
        }
        this.resetAllOptionsFromBindings();
    }

    private void registerSearchIndex() {
        for (ModOptions modConfig : this.modOptions) {
            modConfig.registerTextSources(this.searchIndex);
        }
    }

    public SearchQuerySession startSearchQuery() {
        return this.searchIndex.startQuery();
    }

    private void registerHook(FlagHook hook) {
        for (class_2960 trigger : hook.getTriggers()) {
            this.flagHooks.computeIfAbsent(trigger, k -> new ObjectArrayList()).add(hook);
        }
    }

    private void collectOptions() {
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    for (Option option : group.options()) {
                        this.options.put(option.id, option);
                        option.setParentConfig(this);
                    }
                }
            }
            if (modConfig.flagHooks() == null) continue;
            for (FlagHook hook : modConfig.flagHooks()) {
                this.registerHook(hook);
            }
        }
    }

    private void applyOptionChanges() {
        Option option;
        int i;
        List<Option> options;
        Object2ReferenceOpenHashMap overrides = new Object2ReferenceOpenHashMap();
        Object2ReferenceOpenHashMap overlays = new Object2ReferenceOpenHashMap();
        for (ModOptions modConfig : this.modOptions) {
            for (OptionOverride override : modConfig.overrides()) {
                if (override.target().method_12836().equals(modConfig.configId())) {
                    throw new IllegalArgumentException("Override by mod '" + modConfig.configId() + "' targets its own option '" + String.valueOf(override.target()) + "'");
                }
                if (overrides.put((Object)override.target(), (Object)override) == null) continue;
                throw new IllegalArgumentException("Multiple overrides for option '" + String.valueOf(override.target()) + "'");
            }
            for (OptionOverlay overlay : modConfig.overlays()) {
                if (overlay.target().method_12836().equals(modConfig.configId())) {
                    throw new IllegalArgumentException("Overlay by mod '" + modConfig.configId() + "' targets its own option '" + String.valueOf(overlay.target()) + "'");
                }
                if (overlays.put((Object)overlay.target(), (Object)overlay) == null) continue;
                throw new IllegalArgumentException("Multiple overlays for option '" + String.valueOf(overlay.target()) + "'");
            }
        }
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    options = group.options();
                    for (i = 0; i < options.size(); ++i) {
                        option = options.get(i);
                        OptionOverride override = (OptionOverride)overrides.get((Object)option.id);
                        if (override == null) continue;
                        Option replacement = override.change();
                        this.exchangeOption(options, i, replacement, option);
                    }
                }
            }
        }
        for (ModOptions modConfig : this.modOptions) {
            for (Page page : modConfig.pages()) {
                for (OptionGroup group : page.groups()) {
                    options = group.options();
                    for (i = 0; i < options.size(); ++i) {
                        option = options.get(i);
                        OptionOverlay overlay = (OptionOverlay)overlays.get((Object)option.id);
                        if (overlay == null) continue;
                        OptionBuilderImpl<?> change = overlay.change();
                        try {
                            Object overlaidOption = change.buildWithBaseOption(option);
                            this.exchangeOption(options, i, (Option)overlaidOption, option);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Failed to apply overlay from '" + overlay.source() + "' to option '" + String.valueOf(option.id) + "'", e);
                        }
                    }
                }
            }
        }
    }

    private void exchangeOption(List<Option> optionGroupList, int i, Option replacement, Option original) {
        optionGroupList.set(i, replacement);
        this.options.remove(original.id);
        this.options.put(replacement.id, replacement);
        replacement.setParentConfig(this);
        original.setParentConfig(null);
    }

    private void collectApplyHooks() {
        for (Option option : this.options.values()) {
            StatefulOption statefulOption;
            Consumer<ConfigState> applyHook;
            if (!(option instanceof StatefulOption) || (applyHook = (statefulOption = (StatefulOption)option).getApplyHook()) == null) continue;
            this.registerHook(new ApplyHookFlagHook(statefulOption.getApplyHookId(), applyHook));
        }
    }

    private void validateDependencies() {
        for (Option option : this.options.values()) {
            for (class_2960 dependency : option.dependencies) {
                if (this.options.containsKey(dependency) || SPECIAL_DEPENDENCIES.contains(dependency)) continue;
                throw new IllegalArgumentException("Option " + String.valueOf(option.id) + " depends on non-existent option " + String.valueOf(dependency));
            }
            option.visitDependentValues(dependent -> {
                if (dependent instanceof DynamicValue) {
                    DynamicValue dynamicValue = (DynamicValue)dependent;
                    for (class_2960 dependency : dependent.getDependencies()) {
                        if (dependency.equals((Object)ConfigState.UPDATE_ON_REBUILD)) {
                            this.globalRebuildDependents.add(dynamicValue);
                            continue;
                        }
                        if (dependency.equals((Object)ConfigState.UPDATE_ON_APPLY) && option instanceof StatefulOption) {
                            StatefulOption statefulOption = (StatefulOption)option;
                            statefulOption.registerApplyDependent(dynamicValue);
                            dynamicValue.allowReadingParentOption(option.id);
                            continue;
                        }
                        Option dependencyOption = this.options.get(dependency);
                        if (!(dependencyOption instanceof StatefulOption)) continue;
                        StatefulOption statefulOption = (StatefulOption)dependencyOption;
                        statefulOption.registerDependent(dynamicValue);
                    }
                }
            });
        }
        ObjectOpenHashSet stack = new ObjectOpenHashSet();
        ObjectOpenHashSet finished = new ObjectOpenHashSet();
        for (Option option : this.options.values()) {
            this.checkDependencyCycles(option, (ObjectOpenHashSet<class_2960>)stack, (ObjectOpenHashSet<class_2960>)finished);
        }
    }

    void invalidateDependents(Collection<DynamicValue<?>> dependents) {
        for (DynamicValue<?> dependent : dependents) {
            dependent.invalidateCache();
        }
    }

    private void checkDependencyCycles(Option option, ObjectOpenHashSet<class_2960> stack, ObjectOpenHashSet<class_2960> finished) {
        if (!stack.add((Object)option.id)) {
            throw new IllegalArgumentException("Cycle detected in dependency graph starting from option " + String.valueOf(option.id));
        }
        for (class_2960 dependency : option.dependencies) {
            Option dependencyOption;
            if (finished.contains((Object)dependency) || (dependencyOption = this.options.get(dependency)) == null) continue;
            this.checkDependencyCycles(dependencyOption, stack, finished);
        }
        stack.remove((Object)option.id);
        finished.add((Object)option.id);
    }

    public void resetAllOptionsFromBindings() {
        for (Option option : this.options.values()) {
            option.resetFromBinding();
        }
    }

    public void applyAllOptions() {
        Set flags = null;
        for (Option option : this.options.values()) {
            StatefulOption statefulOption;
            class_2960 applyHookId;
            if (!option.applyChanges()) continue;
            Set<class_2960> optionFlags = option.getFlags();
            if (optionFlags != null && !optionFlags.isEmpty()) {
                if (flags == null) {
                    flags = new ObjectOpenHashSet();
                }
                flags.addAll(optionFlags);
            }
            if (!(option instanceof StatefulOption) || (applyHookId = (statefulOption = (StatefulOption)option).getApplyHookId()) == null) continue;
            if (flags == null) {
                flags = new ObjectOpenHashSet();
            }
            flags.add(applyHookId);
        }
        this.flushStorageHandlers();
        if (flags == null) {
            return;
        }
        this.processFlags(flags);
    }

    public void applyOption(class_2960 id) {
        Set<class_2960> flags = null;
        Option option = this.options.get(id);
        if (option != null && option.applyChanges()) {
            flags = option.getFlags();
        }
        this.flushStorageHandlers();
        if (flags == null) {
            return;
        }
        this.processFlags(flags);
    }

    public boolean anyOptionChanged() {
        for (Option option : this.options.values()) {
            if (!option.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void invalidateGlobalRebuildDependents() {
        this.invalidateDependents(this.globalRebuildDependents);
    }

    void notifyStorageWrite(StorageEventHandler handler) {
        this.pendingStorageHandlers.add(handler);
    }

    void flushStorageHandlers() {
        for (StorageEventHandler handler : this.pendingStorageHandlers) {
            handler.afterSave();
        }
        this.pendingStorageHandlers.clear();
    }

    public Option getOption(class_2960 id) {
        return this.options.get(id);
    }

    public List<ModOptions> getModOptions() {
        return this.modOptions;
    }

    private void processFlags(Set<class_2960> flags) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            if (flags.contains(OptionFlag.REQUIRES_RENDERER_RELOAD.getId())) {
                client.field_1769.method_3279();
            } else if (flags.contains(OptionFlag.REQUIRES_RENDERER_UPDATE.getId())) {
                client.field_1769.method_3292();
            }
        }
        if (flags.contains(OptionFlag.REQUIRES_ASSET_RELOAD.getId())) {
            client.method_24041(((Integer)client.field_1690.method_42563().method_41753()).intValue());
            client.method_1513();
        }
        if (flags.contains(OptionFlag.REQUIRES_VIDEOMODE_RELOAD.getId())) {
            client.method_22683().method_4475();
        }
        if (flags.contains(OptionFlag.REQUIRES_GAME_RESTART.getId())) {
            Console.instance().logMessage(MessageLevel.WARN, "sodium.console.game_restart", true, 10.0);
        }
        this.triggeredHooks.clear();
        Set<class_2960> immutableFlags = Collections.unmodifiableSet(flags);
        for (class_2960 flag : flags) {
            Collection<FlagHook> hooks = this.flagHooks.get(flag);
            if (hooks == null) continue;
            for (FlagHook hook : hooks) {
                if (!this.triggeredHooks.add(hook)) continue;
                hook.accept(immutableFlags, this);
            }
        }
    }

    public boolean readBooleanOption(class_2960 id, boolean appliedValue) {
        Option option = this.options.get(id);
        if (option instanceof BooleanOption) {
            BooleanOption booleanOption = (BooleanOption)option;
            if (appliedValue) {
                return (Boolean)booleanOption.getAppliedValue();
            }
            return (Boolean)booleanOption.getValidatedValue();
        }
        throw new IllegalArgumentException("Can't read boolean value from option with id " + String.valueOf(id));
    }

    public int readIntOption(class_2960 id, boolean appliedValue) {
        Option option = this.options.get(id);
        if (option instanceof IntegerOption) {
            IntegerOption intOption = (IntegerOption)option;
            if (appliedValue) {
                return (Integer)intOption.getAppliedValue();
            }
            return (Integer)intOption.getValidatedValue();
        }
        throw new IllegalArgumentException("Can't read int value from option with id " + String.valueOf(id));
    }

    public <E extends Enum<E>> E readEnumOption(class_2960 id, Class<E> enumClass, boolean appliedValue) {
        Option option = this.options.get(id);
        if (option instanceof EnumOption) {
            EnumOption enumOption = (EnumOption)option;
            if (enumOption.enumClass != enumClass) {
                throw new IllegalArgumentException("Enum class mismatch for option with id " + String.valueOf(id) + ": requested " + String.valueOf(enumClass) + ", option has " + String.valueOf(enumOption.enumClass));
            }
            if (appliedValue) {
                return (E)((Enum)enumClass.cast(enumOption.getAppliedValue()));
            }
            return (E)((Enum)enumClass.cast(enumOption.getValidatedValue()));
        }
        throw new IllegalArgumentException("Can't read enum value from option with id " + String.valueOf(id));
    }

    @Override
    public boolean readBooleanOption(class_2960 id) {
        return this.readBooleanOption(id, true);
    }

    @Override
    public int readIntOption(class_2960 id) {
        return this.readIntOption(id, true);
    }

    @Override
    public <E extends Enum<E>> E readEnumOption(class_2960 id, Class<E> enumClass) {
        return this.readEnumOption(id, enumClass, true);
    }

    private record ApplyHookFlagHook(class_2960 applyHookId, Consumer<ConfigState> applyHook) implements FlagHook
    {
        @Override
        public Collection<class_2960> getTriggers() {
            return Set.of(this.applyHookId);
        }

        @Override
        public void accept(Collection<class_2960> identifiers, ConfigState configState) {
            this.applyHook.accept(configState);
        }
    }
}

