/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5135;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class AttributeReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("attribute");
    private final List<class_2960> ids = new ArrayList<class_2960>();
    private final class_6880<class_1320> attribute;
    private final float value;
    private final class_1322.class_1323 operation;

    private AttributeReward(class_6880<class_1320> attribute, float value, class_1322.class_1323 operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, AttributeReward::parse);
    }

    private static Result<AttributeReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(AttributeReward::parse, context));
    }

    private static Result<AttributeReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optAttribute = rootObject.get("attribute").andThen(attributeElement -> BuiltinJson.parseAttribute(attributeElement).andThen(attribute -> {
            class_6880 attributeEntry = class_7923.field_41190.method_47983(attribute);
            if (class_5135.method_26873((class_1299)class_1299.field_6097).method_27310(attributeEntry)) {
                return Result.success(attributeEntry);
            }
            return Result.failure(attributeElement.getPath().createProblem("Expected a valid player attribute"));
        })).ifFailure(problems::add).getSuccess();
        Optional<Float> optValue = rootObject.getFloat("value").ifFailure(problems::add).getSuccess();
        Optional optOperation = rootObject.get("operation").andThen(BuiltinJson::parseAttributeOperation).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AttributeReward((class_6880<class_1320>)((class_6880)optAttribute.orElseThrow()), optValue.orElseThrow().floatValue(), (class_1322.class_1323)optOperation.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public void update(RewardUpdateContext context) {
        int count = context.getCount();
        class_1324 instance = Objects.requireNonNull(context.getPlayer().method_5996(this.attribute));
        while (this.ids.size() < count) {
            this.ids.add(SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789")));
        }
        for (int i = 0; i < this.ids.size(); ++i) {
            class_2960 id = this.ids.get(i);
            if (instance.method_6199(id) == null) {
                if (i >= count) continue;
                instance.method_26835(new class_1322(id, (double)this.value, this.operation));
                continue;
            }
            if (i < count) continue;
            instance.method_6200(id);
        }
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (class_3222 player : context.getServer().method_3760().method_14571()) {
            class_1324 instance = Objects.requireNonNull(player.method_5996(this.attribute));
            for (class_2960 id : this.ids) {
                instance.method_6200(id);
            }
        }
        this.ids.clear();
    }
}

