/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.calculation.prototype;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.calculation.prototype.PrototypeOperation;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.calculation.prototype.PrototypeOperationImpl;
import net.puffish.skillsmod.util.LegacyUtils;

public class PrototypeImpl<T>
implements Prototype<T> {
    private final Map<class_2960, Function<OperationConfigContext, Result<PrototypeOperation<T, ?>, Problem>>> factories = new HashMap();
    private final class_2960 id;

    public PrototypeImpl(class_2960 id) {
        this.id = id;
    }

    private <R> Function<OperationConfigContext, Result<PrototypeOperation<T, ?>, Problem>> createFunction(Prototype<R> prototype, OperationFactory<T, R> factory) {
        return context -> factory.apply((OperationConfigContext)context).mapSuccess(o -> new PrototypeOperationImpl(prototype, o));
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public <R> void registerOperation(class_2960 id, Prototype<R> prototype, OperationFactory<T, R> factory) {
        this.register(id, this.createFunction(prototype, factory));
    }

    @Override
    public Optional<Result<PrototypeOperation<T, ?>, Problem>> getOperation(class_2960 id, OperationConfigContext context) {
        Function<OperationConfigContext, Result<PrototypeOperation<OperationConfigContext, ?>, Problem>> function = this.factories.get(id);
        if (function == null || function instanceof LegacyFunction && LegacyUtils.isRemoved(3, context)) {
            return Optional.empty();
        }
        return Optional.of(function.apply(context));
    }

    public <R> void registerLegacyOperation(class_2960 id, Prototype<R> prototype, OperationFactory<T, R> factory) {
        this.register(id, new LegacyFunction<T>(this.createFunction(prototype, factory)));
    }

    public void registerAlias(class_2960 id, class_2960 existingId) {
        this.register(id, new LegacyFunction<T>(Objects.requireNonNull(this.factories.get(existingId))));
    }

    private void register(class_2960 id, Function<OperationConfigContext, Result<PrototypeOperation<T, ?>, Problem>> factory) {
        this.factories.compute(id, (key, old) -> {
            if (old == null) {
                return factory;
            }
            throw new IllegalStateException("Trying to add duplicate key `" + String.valueOf(key) + "` to registry");
        });
    }

    private record LegacyFunction<T>(Function<OperationConfigContext, Result<PrototypeOperation<T, ?>, Problem>> parent) implements Function<OperationConfigContext, Result<PrototypeOperation<T, ?>, Problem>>
    {
        @Override
        public Result<PrototypeOperation<T, ?>, Problem> apply(OperationConfigContext operationConfigContext) {
            return this.parent.apply(operationConfigContext);
        }
    }
}

