/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.commands.arguments.SkillArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class SkillsCommand {
    public static LiteralArgumentBuilder<class_2168> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skills").requires((Predicate)class_2170.method_71774((class_12090)class_2170.field_31839))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).then(class_2170.method_9244((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::unlock)))))).then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).then(class_2170.method_9244((String)"skill", (ArgumentType)SkillArgumentType.skillFromCategory("category")).executes(SkillsCommand::lock)))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(SkillsCommand::reset))));
    }

    private static int unlock(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (class_3222 player : players) {
            skill.unlock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.unlock", category.getId(), skill.getId());
        return players.size();
    }

    private static int lock(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        Skill skill = SkillArgumentType.getSkillFromCategory(context, "skill", category);
        for (class_3222 player : players) {
            skill.lock(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.lock", category.getId(), skill.getId());
        return players.size();
    }

    private static int reset(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (class_3222 player : players) {
            category.resetSkills(player);
        }
        CommandUtils.sendSuccess(context, players, "skills.reset", category.getId());
        return players.size();
    }
}

