/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Experience;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class ExperienceCommand {
    public static LiteralArgumentBuilder<class_2168> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"experience").requires((Predicate)class_2170.method_71774((class_12090)class_2170.field_31839))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.categoryOnlyWithExperience()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ExperienceCommand::add)))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.categoryOnlyWithExperience()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ExperienceCommand::set)))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"category", (ArgumentType)CategoryArgumentType.categoryOnlyWithExperience()).executes(ExperienceCommand::get))));
    }

    private static int add(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategoryOnlyWithExperience(context, "category");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Experience experience = category.getExperience().orElseThrow();
        for (class_3222 player : players) {
            experience.addTotal(player, amount);
        }
        CommandUtils.sendSuccess(context, players, "experience.add", amount, category.getId());
        return players.size();
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"players");
        Category category = CategoryArgumentType.getCategoryOnlyWithExperience(context, "category");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Experience experience = category.getExperience().orElseThrow();
        for (class_3222 player : players) {
            experience.setTotal(player, amount);
        }
        CommandUtils.sendSuccess(context, players, "experience.set", amount, category.getId());
        return players.size();
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        Category category = CategoryArgumentType.getCategoryOnlyWithExperience(context, "category");
        Experience experience = category.getExperience().orElseThrow();
        int amount = experience.getTotal(player);
        CommandUtils.sendSuccess(context, player, "experience.get", amount, category.getId());
        return amount;
    }
}

