/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_12137;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import net.minecraft.class_8690;
import net.puffish.skillsmod.access.DrawContextAccess;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;

public class TextureBatchedRenderer {
    private final Map<class_2960, List<TextureEmit>> batch = new HashMap<class_2960, List<TextureEmit>>();

    public void emitTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, int color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitSprite(class_332 context, class_1058 sprite, class_8690 scaling, int x, int y, int width, int height, int color) {
        if (scaling instanceof class_8690.class_8693) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
        } else if (scaling instanceof class_8690.class_8694) {
            class_8690.class_8694 tile = (class_8690.class_8694)scaling;
            this.emitSpriteTile(context, sprite, tile, x, y, width, height, color);
        } else if (scaling instanceof class_8690.class_8691) {
            class_8690.class_8691 nineSlice = (class_8690.class_8691)scaling;
            this.emitSpriteNineSlice(context, sprite, nineSlice, x, y, width, height, color);
        }
    }

    private void emitSpriteTile(class_332 context, class_1058 sprite, class_8690.class_8694 tile, int x, int y, int width, int height, int color) {
        if (width <= 0 || height <= 0 || tile.comp_1644() <= 0 || tile.comp_1645() <= 0) {
            return;
        }
        for (int tileX = 0; tileX < width; tileX += tile.comp_1644()) {
            int tileWidth = Math.min(tile.comp_1644(), width - tileX);
            for (int tileY = 0; tileY < height; tileY += tile.comp_1645()) {
                int tileHeight = Math.min(tile.comp_1645(), height - tileY);
                this.emitSpriteStretch(context, sprite, x + tileX, y + tileY, tileWidth, tileHeight, color);
            }
        }
    }

    private void emitSpriteNineSlice(class_332 context, class_1058 sprite, class_8690.class_8691 nineSlice, int x, int y, int width, int height, int color) {
        int tileWidth;
        int tileX;
        if (width == nineSlice.comp_1637() && height == nineSlice.comp_1638()) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
            return;
        }
        class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
        int left = Math.min(border.comp_1640(), width / 2);
        int top = Math.min(border.comp_1641(), height / 2);
        int right = Math.min(border.comp_1642(), width / 2);
        int bottom = Math.min(border.comp_1643(), height / 2);
        if (width == nineSlice.comp_1637()) {
            this.emitTextureBatched(context, sprite.method_45852(), x, y, x + width, y + top, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
                int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.method_45852(), x, y + tileY, x + nineSlice.comp_1637(), y + tileY + tileHeight, sprite.method_4594(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            }
            this.emitTextureBatched(context, sprite.method_45852(), x, y + height - bottom, x + width, y + height, sprite.method_4594(), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4575(), color);
            return;
        }
        if (height == nineSlice.comp_1638()) {
            this.emitTextureBatched(context, sprite.method_45852(), x, y, x + left, y + height, sprite.method_4594(), sprite.method_4593(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
            for (int tileX2 = left; tileX2 < width - right; tileX2 += nineSlice.comp_1637() - left - right) {
                int tileWidth2 = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX2);
                this.emitTextureBatched(context, sprite.method_45852(), x + tileX2, y, x + tileX2 + tileWidth2, y + nineSlice.comp_1638(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4580((float)(left + tileWidth2) / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
            }
            this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y, x + width, y + height, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4577(), sprite.method_4575(), color);
            return;
        }
        this.emitTextureBatched(context, sprite.method_45852(), x, y, x + left, y + right, sprite.method_4594(), sprite.method_4593(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)right / (float)nineSlice.comp_1637()), color);
        this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y, x + width, y + top, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4577(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
        this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y + height - bottom, x + width, y + height, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4575(), color);
        this.emitTextureBatched(context, sprite.method_45852(), x, y + height - bottom, x + left, y + height, sprite.method_4594(), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
        for (tileX = left; tileX < width - right; tileX += nineSlice.comp_1637() - left - right) {
            tileWidth = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX);
            this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y, x + tileX + tileWidth, y + top, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
            this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y + height - bottom, x + tileX + tileWidth, y + height, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
        }
        for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
            int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
            this.emitTextureBatched(context, sprite.method_45852(), x, y + tileY, x + left, y + tileY + tileHeight, sprite.method_4594(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y + tileY, x + width, y + tileY + tileHeight, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
        }
        for (tileX = left; tileX < width - right; tileX += nineSlice.comp_1637() - left - right) {
            tileWidth = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
                int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y + tileY, x + tileX + tileWidth, y + tileY + tileHeight, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            }
        }
    }

    private void emitSpriteStretch(class_332 context, class_1058 sprite, int x, int y, int width, int height, int color) {
        this.emitTextureBatched(context, sprite.method_45852(), x, y, x + width, y + height, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575(), color);
    }

    private void emitTextureBatched(class_332 context, class_2960 texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix3x2fStack matrix = context.method_51448();
        Vector2f v1 = matrix.transformPosition(new Vector2f(minX, minY));
        Vector2f v2 = matrix.transformPosition(new Vector2f(minX, maxY));
        Vector2f v3 = matrix.transformPosition(new Vector2f(maxX, maxY));
        Vector2f v4 = matrix.transformPosition(new Vector2f(maxX, minY));
        emits.add(new TextureEmit(v1.x, v1.y, v2.x, v2.y, v3.x, v3.y, v4.x, v4.y, minU, minV, maxU, maxV, color));
    }

    public void draw(class_332 context, class_1060 textureManager, final class_8030 scissorArea) {
        if (this.batch.isEmpty()) {
            return;
        }
        for (Map.Entry<class_2960, List<TextureEmit>> entry : this.batch.entrySet()) {
            final GpuTextureView texture = textureManager.method_4619(entry.getKey()).method_71659();
            List<TextureEmit> emits = entry.getValue();
            final class_8030 bounds = TextureBatchedRenderer.calcBounds(emits);
            final List<TextureEmit> emitsCopy = List.copyOf(emits);
            DrawContextAccess contextAccess = (DrawContextAccess)context;
            contextAccess.getState().method_70919(new class_11244(){

                public void method_70917(class_4588 vc) {
                    for (TextureEmit emit : emitsCopy) {
                        vc.method_22912(emit.x1, emit.y1, 0.0f).method_22913(emit.minU, emit.minV).method_39415(emit.color);
                        vc.method_22912(emit.x2, emit.y2, 0.0f).method_22913(emit.minU, emit.maxV).method_39415(emit.color);
                        vc.method_22912(emit.x3, emit.y3, 0.0f).method_22913(emit.maxU, emit.maxV).method_39415(emit.color);
                        vc.method_22912(emit.x4, emit.y4, 0.0f).method_22913(emit.maxU, emit.minV).method_39415(emit.color);
                    }
                }

                public RenderPipeline comp_4055() {
                    return class_10799.field_56883;
                }

                public class_11231 comp_4056() {
                    return class_11231.method_70900((GpuTextureView)texture, (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST));
                }

                public class_8030 comp_4069() {
                    return scissorArea;
                }

                public class_8030 comp_4274() {
                    return bounds;
                }
            });
        }
        this.batch.clear();
    }

    @NotNull
    private static class_8030 calcBounds(List<TextureEmit> emits) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (TextureEmit emit : emits) {
            minX = Math.min(minX, emit.x1);
            minX = Math.min(minX, emit.x2);
            minX = Math.min(minX, emit.x3);
            minX = Math.min(minX, emit.x4);
            minY = Math.min(minY, emit.y1);
            minY = Math.min(minY, emit.y2);
            minY = Math.min(minY, emit.y3);
            minY = Math.min(minY, emit.y4);
            maxX = Math.max(maxX, emit.x1);
            maxX = Math.max(maxX, emit.x2);
            maxX = Math.max(maxX, emit.x3);
            maxX = Math.max(maxX, emit.x4);
            maxY = Math.max(maxY, emit.y1);
            maxY = Math.max(maxY, emit.y2);
            maxY = Math.max(maxY, emit.y3);
            maxY = Math.max(maxY, emit.y4);
        }
        return new class_8030(class_3532.method_15375((float)minX), class_3532.method_15375((float)minY), class_3532.method_15386((float)(maxX - minX)), class_3532.method_15386((float)(maxY - minY)));
    }

    private record TextureEmit(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float minU, float minV, float maxU, float maxV, int color) {
    }
}

