/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.herenthere.config;

import dev.terminalmc.herenthere.util.Localization;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Alias {
    public static final String DATA_FORMAT = "%s ||| %s";
    public static final String DATA_PATTERN_STRING = "^(.*) \\|\\|\\| (.*)$";
    public static final Pattern DATA_PATTERN = Pattern.compile("^(.*) \\|\\|\\| (.*)$");
    public String alias;
    public String replacement;

    public Alias(String alias, String replacement) {
        this.alias = alias;
        this.replacement = replacement;
    }

    public String toDataString() {
        return String.format(DATA_FORMAT, this.alias, this.replacement);
    }

    public static Alias fromDataString(String dataString) throws ParseException {
        Matcher matcher = DATA_PATTERN.matcher(dataString = dataString.strip());
        if (!matcher.matches()) {
            throw new ParseException(Localization.localized("error", "alias.pattern", DATA_PATTERN_STRING).getString(), 0);
        }
        String alias = matcher.group(1);
        String replacement = matcher.group(2);
        return new Alias(alias, replacement);
    }
}

