/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class ResourceEvent<T> {
    private final List<T> handler = new ArrayList<T>();
    private final T invoker;

    public ResourceEvent(@NotNull Function<List<T>, T> factory) {
        this.invoker = factory.apply(this.handler);
    }

    public T invoker() {
        return this.invoker;
    }

    public void register(T listener) {
        Objects.requireNonNull(listener, "Tries to register null Listener!");
        this.handler.addLast(listener);
    }
}

