/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.arguments.CContainerSuggestionProvider;
import net.jsa2025.calcmod.commands.arguments.ContainerSuggestionProvider;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class SignalToItems {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LSignal To Items:\u00a7r\u00a7f\n   Given a container and a desired comparator signal strength \u00a77\u00a7o(can be in expression form)\u00a7r\u00a7f, returns the number of items needed to achieve that signal strength.\n    \u00a7eUsage: /calc signaltoitems <container> <signal>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"signaltoitems").then(ClientCommandManager.argument((String)"container", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new CContainerSuggestionProvider()).then(ClientCommandManager.argument((String)"signal", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = SignalToItems.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"container"), StringArgumentType.getString((CommandContext)ctx, (String)"signal"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("signaltoitems");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"signaltoitems").then(class_2170.method_9244((String)"container", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ContainerSuggestionProvider()).then(class_2170.method_9244((String)"signal", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = SignalToItems.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"container"), StringArgumentType.getString((CommandContext)ctx, (String)"signal"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("signaltoitems");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String container, String signal) {
        double strength = CalcCommand.getParsedExpression(player, signal, new Integer[0]);
        Map<String, Integer> containers = ContainerSuggestionProvider.containers;
        double stackAmount = containers.get(container).intValue();
        double secondlevel = stackAmount * 32.0 / 7.0;
        double item64 = Math.max(strength, Math.ceil(secondlevel * (strength - 1.0)));
        String stackable16 = "Not Possible";
        String stackable1 = "Not Possible";
        double secondlevel16 = stackAmount * 8.0 / 7.0;
        double item16 = Math.max(strength, Math.ceil(secondlevel16 * (strength - 1.0)));
        double item16nextstrength = Math.ceil(secondlevel16 * strength);
        double secondlevel1 = stackAmount / 14.0;
        double item1 = Math.ceil(secondlevel1 * (strength - 1.0));
        if (item1 < 0.0) {
            item1 = 0.0;
        } else if (item1 == 0.0) {
            item1 = 1.0;
        }
        double item1nextstrength = Math.ceil(secondlevel1 * strength);
        if (item16nextstrength > item16) {
            stackable16 = CalcCommand.getParsedStack(item16, 16);
        }
        if (item1nextstrength > item1) {
            stackable1 = nf.format(item1);
        }
        CalcMessageBuilder message = new CalcMessageBuilder().addFromArray(new String[]{"Items required for 64 stackable: ", "result", "\nItems required for 16 stackable: ", "result", "\nItems required for non-stackable: ", "result"}, new String[0], new String[]{CalcCommand.getParsedStack(item64, 64), stackable16, stackable1});
        if (strength > 15.0) {
            message.addString("\n\u00a7cError: Signal Strength out of range (0, 15)");
        }
        return message;
    }
}

