/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1078;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.annotations.ConfigEntry;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.tooltip.ResourceConfigTextTooltip;
import net.xstopho.resourceconfigapi.client.gui.tooltip.ResourceTooltipProvider;

public class GuiUtils {
    private static final class_2960 directImpact = ConfigConstants.of("textures/gui/sprites/icon/direct_impact.png");
    private static final class_2960 worldRestart = ConfigConstants.of("textures/gui/sprites/icon/world_restart.png");
    private static final class_2960 gameRestart = ConfigConstants.of("textures/gui/sprites/icon/game_restart.png");

    public static class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public static void renderIcon(ResourceConfigScreen screen, class_332 guiGraphics, Field field, int xPos, int yPos, int mouseX, int mouseY) {
        ConfigEntry config = field.getAnnotation(ConfigEntry.class);
        if (!config.needsGameRestart() && !config.needsWorldRestart()) {
            GuiUtils.renderIcon(screen, guiGraphics, directImpact, ClientConstants.DIRECT_IMPACT_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
        if (config.needsGameRestart()) {
            GuiUtils.renderIcon(screen, guiGraphics, gameRestart, ClientConstants.NEEDS_GAME_RESTART_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
        if (config.needsWorldRestart()) {
            GuiUtils.renderIcon(screen, guiGraphics, worldRestart, ClientConstants.NEEDS_WORLD_RESTART_TOOLTIP, xPos, yPos, mouseX, mouseY);
        }
    }

    public static void renderIcon(ResourceConfigScreen screen, class_332 guiGraphics, class_2960 texture, class_2561 tooltip, int xPos, int yPos, int mouseX, int mouseY) {
        guiGraphics.method_25290(class_10799.field_56883, texture, xPos, yPos, 0.0f, 0.0f, 11, 11, 11, 11);
        if (GuiUtils.inBounds(xPos, yPos, xPos + 11, yPos + 11, mouseX, mouseY)) {
            screen.addTooltip(GuiUtils.createTooltip(tooltip));
        }
    }

    public static void drawStringWithTooltip(ResourceConfigScreen screen, ResourceTooltipProvider provider, class_332 guiGraphics, class_2561 title, class_2561 tooltip, int xPos, int yPos, int mouseX, int mouseY) {
        if (title != null) {
            guiGraphics.method_51439(GuiUtils.getFont(), title, xPos, yPos, -1, false);
            if (tooltip != null) {
                int xMax = xPos + GuiUtils.getFont().method_1727(title.getString());
                Objects.requireNonNull(GuiUtils.getFont());
                int yMax = yPos + 9;
                if (GuiUtils.hasTranslation(tooltip) && GuiUtils.inBounds(xPos, yPos, xMax, yMax, mouseX, mouseY)) {
                    screen.addTooltip(provider.getTooltip());
                }
            }
        }
    }

    public static ResourceConfigTextTooltip createTooltip(class_2561 component) {
        List sequence = GuiUtils.getFont().method_1728((class_5348)component, 170);
        return new ResourceConfigTextTooltip(sequence);
    }

    public static boolean inBounds(int xPos, int yPos, int xMax, int yMax, int mouseX, int mouseY) {
        return xPos <= mouseX && xMax >= mouseX && yPos <= mouseY && yMax >= mouseY;
    }

    public static boolean hasTranslation(class_2561 component) {
        String key = GuiUtils.getComponentKey(component);
        String translated = class_1078.method_10517().method_48307(key);
        return !translated.equals(key);
    }

    private static String getComponentKey(class_2561 component) {
        String fullKey = component.toString();
        return fullKey.substring(17, fullKey.length() - 11);
    }
}

