/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.widget.value_list.base;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.screen.ResourceConfigScreen;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;

public abstract class CharSequenceEntry<T>
extends BaseEntry {
    private final Object defaultValue;
    private final Field field;
    private final class_4185 reset;
    private final class_4185 undo;
    protected final class_342 editBox;

    public CharSequenceEntry(ResourceConfigScreen screen, String modId, String fileName, String key, Field field, Object defaultValue) {
        super(screen, modId, fileName, key, class_124.field_1068);
        this.defaultValue = defaultValue;
        this.field = field;
        this.reset = class_4185.method_46430((class_2561)ClientConstants.RESET, button -> this.resetValues()).method_46436(GuiUtils.hasTranslation(ClientConstants.RESET_TOOLTIP) ? class_7919.method_47407((class_2561)ClientConstants.RESET_TOOLTIP) : null).method_46434(0, 0, 50, 20).method_46431();
        this.undo = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> this.undoChanges()).method_46436(GuiUtils.hasTranslation(ClientConstants.UNDO_TOOLTIP) ? class_7919.method_47407((class_2561)ClientConstants.UNDO_TOOLTIP) : null).method_46434(0, 0, 20, 20).method_46431();
        this.undo.field_22763 = false;
        this.editBox = new class_342(this.getFont(), this.getWidgetWidth(), 18, (class_2561)class_2561.method_43473());
        this.editBox.method_1852(this.getFieldValue().toString());
        this.editBox.method_1863(s -> {
            this.undo.field_22763 = !Objects.equals(s, this.getFieldValue().toString());
        });
        this.children.add(this.editBox);
        this.children.add(this.reset);
        this.children.add(this.undo);
    }

    @Override
    public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        GuiUtils.drawStringWithTooltip(this.screen, this, guiGraphics, this.label, this.tooltip, this.method_73380() + 13, this.method_73382() + 6, mouseX, mouseY);
        this.undo.method_48229(this.method_73380() + this.method_73387() - this.undo.method_25368() - this.reset.method_25368(), this.method_73382());
        this.reset.method_48229(this.method_73380() + this.method_73387() - this.reset.method_25368(), this.method_73382());
        this.editBox.method_48229(this.method_73380() + this.method_73387() - this.getWidgetWidth(), this.method_73382() + 1);
        this.editBox.method_25358(this.getWidgetWidth() - (this.undo.method_25368() + this.reset.method_25368()) - 1);
        this.editBox.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.reset.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.undo.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_25290(class_10799.field_56883, this.undoSprite, this.undo.method_46426() + 2, this.undo.method_46427() + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        GuiUtils.renderIcon(this.screen, guiGraphics, this.field, this.method_73380(), this.method_73382() + 4, mouseX, mouseY);
    }

    public abstract T getValue();

    @Override
    public void undoChanges() {
        this.editBox.method_1852(this.getFieldValue().toString());
        this.undo.field_22763 = false;
    }

    @Override
    public void resetValues() {
        this.editBox.method_1852(this.defaultValue.toString());
        try {
            this.field.set(this.field, this.defaultValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set default value for field: " + this.field.getName() + "\n" + String.valueOf(e));
        }
    }

    @Override
    public void saveValues() {
        try {
            this.field.set(this.field, this.getValue());
            this.undo.field_22763 = false;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to save new Value for Field %s", this.field.getName()));
        }
    }

    protected T getFieldValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Failed to get Value for Field '%s'", this.field.getName()));
        }
    }
}

