/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourceconfigapi.client.gui.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.xstopho.resourceconfigapi.ConfigConstants;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourceconfigapi.api.ConfigType;
import net.xstopho.resourceconfigapi.client.ClientConstants;
import net.xstopho.resourceconfigapi.client.gui.widget.ConfigTab;
import net.xstopho.resourceconfigapi.client.gui.widget.value_list.base.BaseEntry;
import net.xstopho.resourceconfigapi.client.util.ClientUtils;
import net.xstopho.resourceconfigapi.client.util.ComponentUtils;
import net.xstopho.resourceconfigapi.client.util.GuiUtils;
import net.xstopho.resourceconfigapi.config.ConfigHolder;
import net.xstopho.resourceconfigapi.config.ModConfig;

public class ResourceConfigScreen
extends class_437 {
    private final class_8132 layout;
    private final class_437 previous;
    private final String modId;
    private final class_8088 manager;
    private class_8089 navigationBar;
    private final Map<class_2960, ConfigHolder> configs = new HashMap<class_2960, ConfigHolder>();
    private final List<class_5684> tooltips = new ArrayList<class_5684>();
    private final ConfigTab commonTab;
    private final ConfigTab clientTab;
    private final ConfigTab serverTab;

    public ResourceConfigScreen(class_437 previous, String modId) {
        super((class_2561)class_2561.method_43470((String)("Config Screen - " + modId)));
        this.modId = modId;
        this.previous = previous;
        this.layout = new class_8132((class_437)this, 32, 32);
        this.manager = new class_8088(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, x$0 -> this.method_37066((class_364)x$0));
        ConfigRegistry.getConfigs().forEach(this::processConfigs);
        this.commonTab = new ConfigTab(ConfigType.COMMON, this.configs);
        this.clientTab = new ConfigTab(ConfigType.CLIENT, this.configs);
        this.serverTab = new ConfigTab(ConfigType.SERVER, this.configs);
    }

    protected void method_25426() {
        class_8089.class_8090 builder = class_8089.method_48623((class_8088)this.manager, (int)this.field_22789);
        if (this.clientTab.containsConfigs()) {
            builder.method_48631(new class_8087[]{this.clientTab});
        }
        if (this.commonTab.containsConfigs() && ClientUtils.isOperator()) {
            builder.method_48631(new class_8087[]{this.commonTab});
        }
        if (this.serverTab.containsConfigs() && ClientUtils.isOperator() && ClientUtils.isMultiplayer()) {
            builder.method_48631(new class_8087[]{this.serverTab});
        }
        this.navigationBar = builder.method_48627();
        class_8667 footer = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)ClientConstants.SAVE_AND_CLOSE, button -> {
            this.consumeAction(BaseEntry::saveValues);
            this.configs.forEach(this::saveConfigChanges);
            this.method_25419();
        }).method_46432(100).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)ClientConstants.RESET_ALL, button -> this.consumeAction(BaseEntry::resetValues)).method_46432(100).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)ClientConstants.CLOSE, button -> {
            this.consumeAction(BaseEntry::undoChanges);
            this.method_25419();
        }).method_46432(100).method_46431());
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        if (!this.navigationBar.method_25396().isEmpty()) {
            this.method_37063((class_364)this.navigationBar);
            this.navigationBar.method_48987(0, true);
        }
        this.method_48640();
        ComponentUtils.loggMissingTranslations(this.modId);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float ticks) {
        super.method_25394(guiGraphics, mouseX, mouseY, ticks);
        guiGraphics.method_25290(class_10799.field_56883, class_437.field_49896, 0, this.field_22790 - 35, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
        this.tooltips.forEach(tooltip -> guiGraphics.method_51435(GuiUtils.getFont(), List.of(tooltip), mouseX, mouseY, class_8001.field_41687, null));
        this.tooltips.clear();
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 256 && this.method_25422()) {
            class_310.method_1551().method_1507(this.previous);
            return true;
        }
        return super.method_25404(keyEvent);
    }

    protected void method_48640() {
        if (this.navigationBar != null && !this.navigationBar.method_25396().isEmpty()) {
            this.navigationBar.method_48618(this.field_22789);
            this.navigationBar.method_49613();
            int i = this.navigationBar.method_48202().method_49619();
            class_8030 screenRectangle = new class_8030(0, i, this.field_22789, this.field_22790 - i * 2 - 10);
            this.manager.method_48616(screenRectangle);
        }
        this.layout.method_48222();
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.previous);
    }

    private void processConfigs(class_2960 location, ModConfig config) {
        if (location.method_12836().equals(this.modId)) {
            this.configs.put(location, new ConfigHolder(config, this));
        }
    }

    private void saveConfigChanges(class_2960 location, ConfigHolder holder) {
        ModConfig config = holder.getConfig();
        if (ClientUtils.isMultiplayer()) {
            switch (config.configType) {
                case CLIENT: {
                    this.saveConfig(holder);
                    break;
                }
                case COMMON: 
                case SERVER: {
                    ClientUtils.sendConfigUpdateToServer(location.toString(), config.toJson().toString());
                }
            }
        } else {
            switch (config.configType) {
                case CLIENT: 
                case COMMON: {
                    this.saveConfig(holder);
                }
            }
        }
    }

    private void saveConfig(ConfigHolder holder) {
        ModConfig config = holder.getConfig();
        ConfigConstants.LOG.info("Saving '{}' config from mod '{}' of type '{}'", new Object[]{holder.getFileName(), config.modId, config.configType});
        config.writeConfig(config.toJson());
    }

    private void consumeAction(Consumer<BaseEntry> consumer) {
        for (Map.Entry<class_2960, ConfigHolder> entry : this.configs.entrySet()) {
            entry.getValue().getEntryList().forEach(consumer);
        }
    }

    public void addTooltip(class_5684 tooltipProvider) {
        this.tooltips.add(tooltipProvider);
    }
}

