/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.event.internal;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.blay09.mods.balm.platform.event.Event;
import net.blay09.mods.balm.platform.event.internal.ArrayBackedEvent;
import net.minecraft.class_2960;

public final class EventFactoryImpl {
    private static final Set<ArrayBackedEvent<?>> ARRAY_BACKED_EVENTS = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    private EventFactoryImpl() {
    }

    public static <T> Event<T> createArrayBacked(Class<? super T> type, Function<T[], T> invokerFactory) {
        ArrayBackedEvent<? super T> event = new ArrayBackedEvent<T>(type, invokerFactory);
        ARRAY_BACKED_EVENTS.add(event);
        return event;
    }

    public static void ensureContainsDefault(class_2960[] defaultPhases) {
        for (class_2960 id : defaultPhases) {
            if (!id.equals((Object)Event.DEFAULT_PHASE)) continue;
            return;
        }
        throw new IllegalArgumentException("The event phases must contain Event.DEFAULT_PHASE.");
    }

    public static void ensureNoDuplicates(class_2960[] defaultPhases) {
        for (int i = 0; i < defaultPhases.length; ++i) {
            for (int j = i + 1; j < defaultPhases.length; ++j) {
                if (!defaultPhases[i].equals((Object)defaultPhases[j])) continue;
                throw new IllegalArgumentException("Duplicate event phase: " + String.valueOf(defaultPhases[i]));
            }
        }
    }
}

