/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.config.internal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.notoml.Notoml;
import net.blay09.mods.balm.platform.config.notoml.NotomlSerializer;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricConfigSaver {
    private static final Logger logger = LoggerFactory.getLogger(FabricConfigSaver.class);

    public static Notoml toNotoml(BalmConfigSchema schema, LoadedConfig config) {
        HashBasedTable properties = HashBasedTable.create();
        HashBasedTable comments = HashBasedTable.create();
        for (ConfiguredProperty<?> rootProperty : schema.rootProperties()) {
            Object value = config.getRaw(rootProperty);
            properties.put((Object)"", (Object)rootProperty.name(), value);
            comments.put((Object)"", (Object)rootProperty.name(), (Object)rootProperty.comment());
        }
        for (ConfigCategory category : schema.categories()) {
            comments.put((Object)category.name(), (Object)"", (Object)category.comment());
            for (ConfiguredProperty<?> property : category.properties()) {
                Object value = config.getRaw(property);
                properties.put((Object)property.category(), (Object)property.name(), value);
                comments.put((Object)property.category(), (Object)property.name(), (Object)property.comment());
            }
        }
        return new Notoml((Table<String, String, Object>)properties, (Table<String, String, String>)comments);
    }

    public static void save(File configFile, BalmConfigSchema schema, LoadedConfig config) throws IOException {
        if (configFile.getParentFile().exists() || configFile.getParentFile().mkdirs()) {
            Notoml notoml = FabricConfigSaver.toNotoml(schema, config);
            try (FileWriter writer = new FileWriter(configFile);){
                NotomlSerializer.serialize(writer, notoml);
            }
        } else {
            logger.error("Failed to save config file {} - could not create config directory", (Object)configFile);
        }
    }
}

